/*********************************************************************************
* C++ Implementation: kbearlogoutputplugin.cpp
* Description:
*                              
* Begin : tis jan 15 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qvbox.h>
#include <qpushbutton.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kaction.h>
#include <kinstance.h>
#include <kmainwindow.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kstatusbar.h>
#include <kgenericfactory.h>
#include <kaboutapplication.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearlogoutputplugin.h"
#include "logoutputconfigwidget.h"
#include "kbearlogview.h"
#include "kbearmainwiniface.h"
#include "connectionmanager.h"
#include "kbearapi.h"
#include "kbearcore.h"
#include "siteinfo.h"

#include "kbearlogoutputplugin.moc"

using namespace KBear;
//-----------------------------------------------
typedef KGenericFactory<KBearLogOutputPlugin> KBearLogOutputPluginFactory;
K_EXPORT_COMPONENT_FACTORY( kbearlogoutput, KBearLogOutputPluginFactory( "kbearlogoutput" ) );
//-----------------------------------------------
KBearLogOutputPlugin::KBearLogOutputPlugin( QObject* parent, const char* , const QStringList& )
  : KBear::KBearPlugin(parent, "KBearLogOutputPlugin")
{
	KGlobal::locale()->insertCatalogue("kbear");
	setInstance( KBearLogOutputPluginFactory::instance() );
	m_logView = new KBearLogView( KBearLogOutputPluginFactory::instance()->config() );
	connect( m_api->core(), SIGNAL( newSite( const SiteInfo& ) ), m_logView, SLOT( slotAddPage( const SiteInfo& ) ) );
	connect( m_api->connectionManager(), SIGNAL( siteClosed( int ) ), m_logView, SLOT( slotRemovePage( int ) ) );
	connect( m_api->connectionManager(), SIGNAL( infoMessage( int, const QString& ) ), m_logView, SLOT( slotLogMessage( int, const QString& ) ) );
}
//-----------------------------------------------
KBearLogOutputPlugin::~KBearLogOutputPlugin() {
	mainWindow()->removeOutputPluginView( m_logView );
	delete m_logView;
}
//-----------------------------------------------
QString KBearLogOutputPlugin::unloadWarning() const {
	return i18n("KBear can't display any log messages if you unload this plugin." );
}
//-----------------------------------------------
void KBearLogOutputPlugin::slotInit()  {
	mainWindow()->embedOutputPluginView( m_logView, i18n( "Log Messages" ), i18n( "Display all log messages from server." ) );
}
//-----------------------------------------------
void KBearLogOutputPlugin::slotUpdateValues()  {
	m_logView->initValues();
}
//-----------------------------------------------
void KBearLogOutputPlugin::slotConfigWidget( KDialogBase* dlg ) {
	QVBox* vbox = dlg->addVBoxPage( i18n("Log"), QString::null,
												KGlobal::iconLoader()->loadIcon("log", KIcon::NoGroup, KIcon::SizeMedium) );
	LogOutputConfigWidget* w = new LogOutputConfigWidget( KBearLogOutputPluginFactory::instance()->config(), vbox, "LogOutputConfigWidget" );
	connect( dlg, SIGNAL( okClicked() ), w, SLOT( slotSaveValues() ) );
	connect( w, SIGNAL( newValues() ), this, SLOT( slotUpdateValues() ) );
}
//-----------------------------------------------
/* We don't add the config to the wizard
void KBearLogOutputPlugin::slotConfigWidget( KWizard* wiz ) {
	LogOutputConfigWidget* w = new LogOutputConfigWidget( KBearLogOutputPluginFactory::instance()->config(), wiz, "LogOutputConfigWidget" );
	wiz->addPage( w, i18n("Log Messages") );
	connect( w, SIGNAL( newValues() ), this, SLOT( slotUpdateValues() ) );
}
*/
//-----------------------------------------------
