/*********************************************************************************
* C++ Implementation: logoutputm_configwidget.cpp
* Description:
*                              
* Begin : tis jan 21 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/
//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qhbuttongroup.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qvaluelist.h>
#include <qdir.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kfiledialog.h>
#include <kurl.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kcolorbutton.h>
#include <kconfig.h>
#include <klineedit.h>
#include <knuminput.h>
#include <kfontdialog.h>
#include <kpushbutton.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "logoutputconfigwidget.h"
#include "kbearlogoutputplugin.h"
#include "misc.h"


#include "logoutputconfigwidget.moc"

using namespace KBear;
//-----------------------------------------------
LogOutputConfigWidget::LogOutputConfigWidget( KConfig* config, QWidget* parent,  const char* name )
    : KBearConfigWidgetIface( parent, name ), m_config( config )
{
//	resize( 401, 334 );
//	setCaption( i18n( "Configure Log" ) );
	QGridLayout* LogOutputConfigWidgetLayout = new QGridLayout( this, 1, 1, 11, 6, "LogOutputConfigWidgetLayout");

	QLabel* infoLabel = new QLabel( this );
	infoLabel->setText( i18n( "<p>Here you can specify how you want the log output to look like. "
															"You can also set if you want KBear to write log information to a file.</p>" ) );
	infoLabel->setAlignment( int( QLabel::WordBreak | QLabel::AlignTop ) );

	LogOutputConfigWidgetLayout->addWidget( infoLabel, 0, 0 );

	QGroupBox* GroupBox1 = new QGroupBox( this, "GroupBox1" );
	GroupBox1->setTitle( i18n( "Color settings" ) );
	GroupBox1->setColumnLayout(0, Qt::Vertical );
	GroupBox1->layout()->setSpacing( 6 );
	GroupBox1->layout()->setMargin( 11 );
	QGridLayout* GroupBox1Layout = new QGridLayout( GroupBox1->layout() );
	GroupBox1Layout->setAlignment( Qt::AlignTop );

	QGridLayout* FontLayout = new QGridLayout( GroupBox1 );
	QLabel* fontLabel = new QLabel( GroupBox1, "fontLabel" );
	fontLabel->setText( i18n( "Select font for log messages:" ) );

	FontLayout->addWidget( fontLabel, 0, 0 );
	
	m_fontSelectButton = new KPushButton( GroupBox1, "m_fontSelectButton" );
	QString toolTip = i18n( "Click this button to change the font for log messages." );
	QToolTip::add( m_fontSelectButton, toolTip );
	QWhatsThis::add( m_fontSelectButton, toolTip );

	FontLayout->addWidget( m_fontSelectButton, 0, 1 );

	GroupBox1Layout->addMultiCellLayout( FontLayout, 0, 0, 0, 1 );
	
	QLabel* commandLabel = new QLabel( GroupBox1, "commandLabel" );
	commandLabel->setText( i18n( "Commands:" ) );

	GroupBox1Layout->addWidget( commandLabel, 1, 0 );

	m_commandColorButton = new KColorButton( GroupBox1, "m_commandColorButton" );
	m_commandColorButton->setText( QString::null );
	toolTip = i18n( "Select color for commands sent to server." );
	QToolTip::add( m_commandColorButton, toolTip );
	QWhatsThis::add( m_commandColorButton, toolTip );

	GroupBox1Layout->addWidget( m_commandColorButton, 1, 1 );

	QLabel* responseLabel = new QLabel( GroupBox1, "responseLabel" );
	responseLabel->setText( i18n( "Response:" ) );

	GroupBox1Layout->addWidget( responseLabel, 2, 0 );

	m_responseColorButton = new KColorButton( GroupBox1, "m_responseColorButton" );
	m_responseColorButton->setText( QString::null );
	toolTip = i18n( "Select color for responses received from server." );
	QToolTip::add( m_responseColorButton, toolTip );
	QWhatsThis::add( m_responseColorButton, toolTip );

	GroupBox1Layout->addWidget( m_responseColorButton, 2, 1 );
	
	QLabel* mulitLineLabel = new QLabel( GroupBox1, "mulitLineLabel" );
	mulitLineLabel->setText( i18n( "Multi line response:" ) );

	GroupBox1Layout->addWidget( mulitLineLabel, 3, 0 );


	m_multiLineColorButton = new KColorButton( GroupBox1, "m_multiLineColorButton" );
	m_multiLineColorButton->setText( QString::null );
	toolTip = i18n( "Select color for multi line responses received from server." );
	QToolTip::add( m_multiLineColorButton, toolTip );
	QWhatsThis::add( m_multiLineColorButton, toolTip );
	
	GroupBox1Layout->addWidget( m_multiLineColorButton, 3, 1 );

	LogOutputConfigWidgetLayout->addWidget( GroupBox1, 1, 0 );

	QGroupBox* m_fileLogGroupBox = new QGroupBox( this, "m_fileLogGroupBox" );
	m_fileLogGroupBox->setTitle( i18n( "File log" ) );
	m_fileLogGroupBox->setColumnLayout(0, Qt::Vertical );
	m_fileLogGroupBox->layout()->setSpacing( 6 );
	m_fileLogGroupBox->layout()->setMargin( 11 );
	QGridLayout* m_fileLogGroupBoxLayout = new QGridLayout( m_fileLogGroupBox->layout() );
	m_fileLogGroupBoxLayout->setAlignment( Qt::AlignTop );

	m_enableFileLogCheckBox = new QCheckBox( m_fileLogGroupBox, "m_enableFileLogCheckBox" );
	m_enableFileLogCheckBox->setText( i18n( "Save logs to file." ) );
	toolTip = i18n( "Check this option if you want KBear to save the logs in files." );
	QToolTip::add( m_enableFileLogCheckBox, toolTip );
	QWhatsThis::add( m_enableFileLogCheckBox, toolTip );

	m_fileLogGroupBoxLayout->addWidget( m_enableFileLogCheckBox, 0, 0 );

	QHButtonGroup* clearLogGroup = new QHButtonGroup( i18n( "Overwrite log files after" ), m_fileLogGroupBox, "clearLogLabel" );
	clearLogGroup->setRadioButtonExclusive( true );
	m_clearLogDayRadioButton = new QRadioButton( i18n("1 Day"), clearLogGroup, "m_clearLogDayRadioButton");
	m_clearLogWeekRadioButton = new QRadioButton( i18n("1 Week"), clearLogGroup, "m_clearLogWeekRadioButton");
	m_clearLogMonthRadioButton = new QRadioButton( i18n("1 Month"), clearLogGroup, "m_clearLogMonthRadioButton");
	m_clearLogNeverRadioButton = new QRadioButton( i18n("Never"), clearLogGroup, "m_clearLogNeverRadioButton");
	
	toolTip = i18n( "Check this option if you want to clear log files every day." );
	QToolTip::add( m_clearLogDayRadioButton, toolTip );
	QWhatsThis::add( m_clearLogDayRadioButton, toolTip );
	toolTip = i18n( "Check this option if you want to clear log files every week." );
	QToolTip::add( m_clearLogWeekRadioButton, toolTip );
	QWhatsThis::add( m_clearLogWeekRadioButton, toolTip );
	toolTip = i18n( "Check this option if you want to clear log files every month." );
	QToolTip::add( m_clearLogMonthRadioButton, toolTip );
	QWhatsThis::add( m_clearLogMonthRadioButton, toolTip );
	toolTip = i18n( "Check this option if you don't want the log files to be cleared.\nWARNING if you check this option the files can grow and be very, very large." );
	QToolTip::add( m_clearLogNeverRadioButton, toolTip );
	QWhatsThis::add( m_clearLogNeverRadioButton, toolTip );

	m_fileLogGroupBoxLayout->addWidget( clearLogGroup, 1, 0 );

	m_showClientCommandsCheckBox = new QCheckBox( m_fileLogGroupBox, "m_showClientCommandsCheckBox" );
	m_showClientCommandsCheckBox->setText( i18n( "Show client commands in log file." ) );
	toolTip = i18n( "Check this option if you want KBear to log all client commands  in the log files." );
	QToolTip::add( m_showClientCommandsCheckBox, toolTip );
	QWhatsThis::add( m_showClientCommandsCheckBox, toolTip );

	m_fileLogGroupBoxLayout->addWidget( m_showClientCommandsCheckBox, 2, 0 );

	m_showServerCommandsCheckBox = new QCheckBox( m_fileLogGroupBox, "m_showServerCommandsCheckBox" );
	m_showServerCommandsCheckBox->setText( i18n( "Show server commands in log file." ) );
	toolTip = i18n( "Check this option if you want KBear to log all server commands in the log files." );
	QToolTip::add( m_showServerCommandsCheckBox, toolTip );
	QWhatsThis::add( m_showServerCommandsCheckBox, toolTip );

	m_fileLogGroupBoxLayout->addWidget( m_showServerCommandsCheckBox, 3, 0 );

	QLabel* m_pathLabel = new QLabel( m_fileLogGroupBox, "m_pathLabel" );
	m_pathLabel->setText( i18n( "Base path for log files:" ) );

	m_fileLogGroupBoxLayout->addWidget( m_pathLabel, 4, 0 );

	m_logFilePathEdit = new KLineEdit( m_fileLogGroupBox, "m_logFilePathEdit" );

	m_fileLogGroupBoxLayout->addWidget( m_logFilePathEdit, 5, 0 );

	m_pathSelectButton = new KPushButton( m_fileLogGroupBox, "m_pathSelectButton" );

	m_fileLogGroupBoxLayout->addWidget( m_pathSelectButton, 5, 1 );
    
	LogOutputConfigWidgetLayout->addWidget( m_fileLogGroupBox, 2, 0 );
	
    
	QSpacerItem* spacer_2 = new QSpacerItem( 0, 25, QSizePolicy::Minimum, QSizePolicy::Expanding );
	LogOutputConfigWidgetLayout->addItem( spacer_2, 2, 0 );
	
	// signals and slots connections
	connect( m_clearLogDayRadioButton, SIGNAL( toggled(bool) ), this, SLOT( slotOverWriteFileLogToggled(bool) ) );
	connect( m_clearLogWeekRadioButton, SIGNAL( toggled(bool) ), this, SLOT( slotOverWriteFileLogToggled(bool) ) );
	connect( m_clearLogMonthRadioButton, SIGNAL( toggled(bool) ), this, SLOT( slotOverWriteFileLogToggled(bool) ) );
	connect( m_clearLogNeverRadioButton, SIGNAL( toggled(bool) ), this, SLOT( slotOverWriteFileLogToggled(bool) ) );
	connect( m_enableFileLogCheckBox, SIGNAL( toggled(bool) ), this, SLOT( setEnableFileLog(bool) ) );
	connect( m_showClientCommandsCheckBox, SIGNAL( toggled(bool) ), this, SLOT( setShowClientCommands(bool) ) );
	connect( m_showServerCommandsCheckBox, SIGNAL( toggled(bool) ), this, SLOT( setShowServerCommands(bool) ) );
	connect( m_fontSelectButton, SIGNAL( clicked() ), this, SLOT( slotChangeFont() ) );
	connect( m_pathSelectButton, SIGNAL( clicked() ), this, SLOT( slotSelectPath() ) );

	// tab order
	setTabOrder( m_commandColorButton, m_responseColorButton );
	setTabOrder( m_responseColorButton, m_multiLineColorButton );
	setTabOrder( m_multiLineColorButton, m_enableFileLogCheckBox );
	setTabOrder( m_enableFileLogCheckBox, m_logFilePathEdit );
	setTabOrder( m_logFilePathEdit, m_pathSelectButton );

	readSettings();
	LogOutputConfigWidgetLayout->activate();
}
//-----------------------------------------------
LogOutputConfigWidget::~LogOutputConfigWidget() {
}
//-----------------------------------------------
void LogOutputConfigWidget::slotChangeFont() {
	KFontDialog::getFont( m_font, false, this );
	m_fontSelectButton->setText( m_font.family() );
}
//-----------------------------------------------
void LogOutputConfigWidget::readSettings( bool /*defaultSettings*/ ) {
	m_config->setGroup( QString::fromLatin1("LogConfig") );
	QValueList<int> c = m_config->readIntListEntry( QString::fromLatin1("CommandColor") );
	if( c.empty() || c.count() < 3 )
		m_commandColor =QColor( "darkblue" );
	else
		m_commandColor = QColor( c[0], c[1], c[2] );
	m_commandColorButton->setColor( m_commandColor );
	
	c = m_config->readIntListEntry( QString::fromLatin1("ResponseColor") );
	if( c.empty() || c.count() < 3 )
		m_responseColor =QColor( "darkred" );
	else
		m_responseColor = QColor( c[0], c[1], c[2] );
	m_responseColorButton->setColor( m_responseColor );
	
	c = m_config->readIntListEntry( QString::fromLatin1("MultiLineColor") );
	if( c.empty() || c.count() < 3 )
		m_multiLineColor =QColor( "darkgreen" );
	else
		m_multiLineColor = QColor( c[0], c[1], c[2] );
	m_multiLineColorButton->setColor( m_multiLineColor );
	
	m_enableFileLog = m_config->readBoolEntry( QString::fromLatin1("EnableFileLog"), false );
	setEnableFileLog( m_enableFileLog );
	
	m_overWriteFileLog = m_config->readUnsignedNumEntry( QString::fromLatin1("OverWriteLogFile"), KBear::DAY );
	setOverWriteFileLog( m_overWriteFileLog );
	
	bool b = m_config->readBoolEntry( QString::fromLatin1("ShowClientCommands"), true );
	setShowClientCommands( b );
	b = m_config->readBoolEntry( QString::fromLatin1("ShowServerCommands"), true );
	setShowServerCommands( b );
	
	m_logFilePath = m_config->readEntry( QString::fromLatin1("LogBasePath"), QDir::homeDirPath() + QString::fromLatin1("/.kbear") );
	setLogFilePath( m_logFilePath );
	
	m_font = m_config->readFontEntry( QString::fromLatin1("Font") );
	m_fontSelectButton->setText( m_font.family() );
	
	
	QPixmap pix = KGlobal::iconLoader()->loadIcon( QString::fromLatin1("folder_open"), KIcon::Toolbar );
	m_pathSelectButton->setPixmap( pix );
}
//-----------------------------------------------
void LogOutputConfigWidget::saveSettings() {
	m_enableFileLog = m_enableFileLogCheckBox->isChecked();
	m_commandColor = m_commandColorButton->color();
	m_responseColor = m_responseColorButton->color();
	m_multiLineColor = m_multiLineColorButton->color();
	m_logFilePath = m_logFilePathEdit->text();

	QValueList<int> c;
	c.append( m_commandColor.red() );
	c.append( m_commandColor.green() );
	c.append( m_commandColor.blue() );
	m_config->writeEntry( QString::fromLatin1("CommandColor"), c );
	c.clear();
	
	c.append( m_responseColor.red() );
	c.append( m_responseColor.green() );
	c.append( m_responseColor.blue() );
	m_config->writeEntry( QString::fromLatin1("ResponseColor"), c );
	c.clear();
	
	c.append( m_multiLineColor.red() );
	c.append( m_multiLineColor.green() );
	c.append( m_multiLineColor.blue() );
	m_config->writeEntry( QString::fromLatin1("MultiLineColor"), c );
	c.clear();
	
	m_config->writeEntry( QString::fromLatin1("EnableFileLog"), m_enableFileLog );
	
	m_config->writeEntry( QString::fromLatin1("OverWriteLogFile"), m_overWriteFileLog );
	
	m_config->writeEntry( QString::fromLatin1("ShowClientCommands"), m_showClientCommands );
	m_config->writeEntry( QString::fromLatin1("ShowServerCommands"), m_showServerCommands );
	
	m_config->writeEntry( QString::fromLatin1("LogBasePath"), m_logFilePath );
	m_config->writeEntry( QString::fromLatin1("Font"), m_font );

	m_config->sync();
	emit newValues();
}
//-----------------------------------------------
void LogOutputConfigWidget::slotSelectPath() {
	QString path = KFileDialog::getExistingDirectory( m_logFilePathEdit->text(), this, i18n( "Select base directory for log files." ) );
	if( ! path.isEmpty() ) {
		m_logFilePathEdit->setText( path );
		m_logFilePath = path;
	}
}
//-----------------------------------------------
void LogOutputConfigWidget::setCommandColor( const QColor& c ) {
	m_commandColor = c;
	m_commandColorButton->setColor( c );
}
//-----------------------------------------------
void LogOutputConfigWidget::setResponseColor( const QColor& c ) {
	m_responseColor = c;
	m_responseColorButton->setColor( c );
}
//-----------------------------------------------
void LogOutputConfigWidget::setMultiLineColor( const QColor& c ) {
	m_multiLineColor = c;
	m_multiLineColorButton->setColor( c );
}
//-----------------------------------------------
void LogOutputConfigWidget::setEnableFileLog( bool e ) {
	m_enableFileLog = e;
	m_enableFileLogCheckBox->setChecked( e );
	m_logFilePathEdit->setEnabled( e );
	m_pathSelectButton->setEnabled( e );
	m_clearLogDayRadioButton->setEnabled( e );
	m_clearLogWeekRadioButton->setEnabled( e );
	m_clearLogMonthRadioButton->setEnabled( e );
	m_clearLogNeverRadioButton->setEnabled( e );
	m_showClientCommandsCheckBox->setEnabled( e );
	m_showServerCommandsCheckBox->setEnabled( e );
}
//-----------------------------------------------
void LogOutputConfigWidget::setLogFilePath( const QString& path ) {
	m_logFilePath = path;
	m_logFilePathEdit->setText( path );
}
//-----------------------------------------------
void LogOutputConfigWidget::setFont( const QFont& font ) {
	m_font = font;
	m_fontSelectButton->setText( font.family() );
}
//-----------------------------------------------
void LogOutputConfigWidget::slotOverWriteFileLogToggled( bool ) {
	if( m_clearLogWeekRadioButton->isChecked() )
		m_overWriteFileLog = KBear::WEEK;
	else if( m_clearLogMonthRadioButton->isChecked() )
		m_overWriteFileLog = KBear::MONTH;
	else if( m_clearLogNeverRadioButton->isChecked() )
		m_overWriteFileLog = KBear::NEVER;
	else
		m_overWriteFileLog = KBear::DAY;
	
}
//-----------------------------------------------
void LogOutputConfigWidget::setOverWriteFileLog( unsigned int o ) {
	m_overWriteFileLog = o;
	switch( o ) {
		case KBear::WEEK:
			m_clearLogWeekRadioButton->setChecked( true );
			break;
		case KBear::MONTH:
			m_clearLogMonthRadioButton->setChecked( true );
			break;
		 case KBear::NEVER: 
			m_clearLogNeverRadioButton->setChecked( true );
			break;
		default: 
			m_clearLogDayRadioButton->setChecked( true );
			break;
	}
}
//-----------------------------------------------
void LogOutputConfigWidget::setShowClientCommands( bool s ) {
	m_showClientCommands = s;
	m_showClientCommandsCheckBox->setChecked( s );
}
//-----------------------------------------------
void LogOutputConfigWidget::setShowServerCommands( bool s ) {
	m_showServerCommands = s;
	m_showServerCommandsCheckBox->setChecked( s );
}
//-----------------------------------------------


