/*********************************************************************************
* C++ Implementation: logoutputconfigwidget.cpp
* Description:
*                              
* Begin : tis jan 21 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/
#ifndef LOGOUTPUTCONFIGWIDGET_H
#define LOGOUTPUTCONFIGWIDGET_H


//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qcolor.h>
#include <qfont.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearconfigwidgetiface.h"

class KColorButton;
class KIntSpinBox;
class KLineEdit;
class KPushButton;
class QCheckBox;
class QRadioButton;
class KConfig;

class LogOutputConfigWidget : public KBear::KBearConfigWidgetIface {
	Q_OBJECT
public:
	/** */
	LogOutputConfigWidget( KConfig* config, QWidget* parent = 0, const char* name = 0 );
	/** */
	~LogOutputConfigWidget();
	/** */
	QColor commandColor() const { return m_commandColor; }
	/** */
	QColor responseColor() const { return m_responseColor; }
	/** */
	QColor multiLineColor() const { return m_multiLineColor; }
	/** */
	bool enableFileLog() const { return m_enableFileLog; }
	/** */
	QFont font() const { return m_font; }
	/** */
	QString logFilePath() const { return m_logFilePath; }
	/** */
	uint overWriteFileLog() const { return m_overWriteFileLog; }
	/** */
	bool showClientCommands() const { return m_showClientCommands; }
	/** */
	bool showServerCommands() const { return m_showServerCommands; }
	/**
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual bool helpEnabled() const { return false; }
	/**
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual void saveSettings();
	/** 
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual void readSettings( bool defaultSettings = false );
public slots:
	/** */
	void setCommandColor( const QColor& c );
	/** */
	void setResponseColor( const QColor& c );
	/** */
	void setMultiLineColor( const QColor& c );
	/** */
	void setEnableFileLog( bool e );
	/** */
	void setLogFilePath( const QString& path );
	/** */
	void setFont( const QFont& font );
	/** */
	void setOverWriteFileLog( uint o );
	/** */
	void setShowClientCommands( bool );
	/** */
	void setShowServerCommands( bool );
	/** */
	void slotSaveValues() { saveSettings(); }
signals:
	void newValues();
private slots:
	void slotSelectPath();
	void slotChangeFont();
	void slotOverWriteFileLogToggled( bool );
private:
	KColorButton* m_commandColorButton;
	KColorButton* m_responseColorButton;
	KColorButton* m_multiLineColorButton;
	QCheckBox* m_enableFileLogCheckBox;
	QCheckBox* m_showClientCommandsCheckBox;
	QCheckBox* m_showServerCommandsCheckBox;
	QRadioButton* m_clearLogDayRadioButton;
	QRadioButton* m_clearLogWeekRadioButton;
	QRadioButton* m_clearLogMonthRadioButton;
	QRadioButton* m_clearLogNeverRadioButton;
	KLineEdit* m_logFilePathEdit;
	KPushButton* m_pathSelectButton;
	KPushButton* m_fontSelectButton;
	QColor m_commandColor;
	QColor m_responseColor;
	QColor m_multiLineColor;
	bool m_enableFileLog;
	bool m_showClientCommands;
	bool m_showServerCommands;
	QString m_logFilePath;
	QFont m_font;
	uint m_overWriteFileLog;
	KConfig* m_config;
};

#endif // LOGOUTPUTCONFIGWIDGET_H
