/*********************************************************************************
* C++ Implementation: kbearrecentconnectionsitem.cpp
* Description:
*
* Begin : lr jun 28 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kconfig.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearrecentconnectionsitem.h"
#include "connectionmanager.h"
#include "misc.h"

using namespace KBear;

#include "kbearrecentconnectionsitem.moc"

//-----------------------------------------------
const QPixmap KBearRecentConnectionsItem::s_connectedPix( started_xpm );
const QPixmap KBearRecentConnectionsItem::s_disconnectedPix( stopped_xpm );
//-----------------------------------------------
KBearRecentConnectionsItem::KBearRecentConnectionsItem( KConfig* config, KListView* view, const QString& text )
	:	QObject( view, text.latin1()), QListViewItem( view, text ),
		m_connectedTimer( this ), m_config( config )
{
	if( m_config->hasGroup( text ) ) {
		m_config->setGroup( text );
		setText( 1, m_config->readEntry( "LastUsed" ) );
		setText( 2, m_config->readEntry( "ConnectedTime" ) );
	}
	else {
		setText( 1, QDateTime::currentDateTime().toString( "ddd MMMM d yyyy hh:mm:ss" ) );
		setText( 2, i18n("Unknown") );
	}
	setPixmap( 0, s_disconnectedPix );

	connect( ConnectionManager::getInstance(), SIGNAL( connected( int ) ), this, SLOT( slotConnected( int ) ) );
	connect( ConnectionManager::getInstance(), SIGNAL( siteClosed( int ) ), this, SLOT( slotConnectionClosed( int ) ) );
	connect( &m_connectedTimer, SIGNAL( timeout() ), this, SLOT( slotUpdateTime() ) );
}
//-----------------------------------------------
KBearRecentConnectionsItem::~KBearRecentConnectionsItem() {
	m_config->setGroup( text( 0 ) );
	m_config->writeEntry( "LastUsed", text( 1 ) );
	m_config->writeEntry( "ConnectedTime", text( 2 ) );
}
//-----------------------------------------------
void KBearRecentConnectionsItem::slotConnected( int ID ) {
	if( m_references.contains( ID ) && ! m_connectedTimer.isActive() ) {
		setText( 1, QDateTime::currentDateTime().toString( "ddd MMMM d yyyy hh:mm:ss" ) );
		m_myTime.setDate( QDateTime::currentDateTime().date() );
		m_myTime.setTime( QDateTime::currentDateTime().time() );
		m_connectedTimer.start( 1000 );
		setPixmap( 0, s_connectedPix );
	}
}
//-----------------------------------------------
void KBearRecentConnectionsItem::slotConnectionClosed( int ID ) {
	if( m_references.contains( ID ) ) {
		removeReference( ID );
		if( m_references.empty() ) {
			m_connectedTimer.stop();
			setPixmap( 0, s_disconnectedPix );
		}
	}
}
//-----------------------------------------------
void KBearRecentConnectionsItem::addReference( int ID ) {
	m_references.push_back( ID );
}
//-----------------------------------------------
void KBearRecentConnectionsItem::removeReference( int ID ) {
	m_references.remove( ID );
}
//-----------------------------------------------
void KBearRecentConnectionsItem::slotUpdateTime() {
	int numOfSecs = m_myTime.secsTo( QDateTime::currentDateTime() );
	int mSecs = m_myTime.time().elapsed();
	QTime t;
	int numOfDays = numOfSecs / 86400; // 60*60*24
	QString tString = QString::null;
	if( numOfDays > 0 ){
		tString = QString("%1 days ").arg( numOfDays );
	}
	else {
		tString = QString::null;
	}
	tString += t.addMSecs( mSecs ).toString();

	setText( 2, tString );
}
//-----------------------------------------------
