/*********************************************************************************
* C++ Implementation: kbearrecentconnectionsoutputwidget..cpp
* Description:
*
* Begin : fre jun 27 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qstringlist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kconfig.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearrecentconnectionsoutputwidget.h"
#include "kbearrecentconnectionsitem.h"


using namespace KBear;

#include "kbearrecentconnectionsoutputwidget.moc"
//-----------------------------------------------
KBearRecentConnectionsOutputWidget::KBearRecentConnectionsOutputWidget( KConfig* config, QWidget* parent, const char* name )
	:	KListView( parent, name ),
		m_config( config )
{
	setItemsMovable( false );
	setRenameable( false );
	setDragEnabled( false );
	setAcceptDrops( false );
	setSelectionModeExt( Single );
	setRootIsDecorated( false );
	setAllColumnsShowFocus( true );

	addColumn( i18n( "Site" ) );
	addColumn( i18n( "Last used" ) );
	addColumn( i18n( "Duration" ) );

	setSorting( 1, false );
}
//-----------------------------------------------
KBearRecentConnectionsOutputWidget::~KBearRecentConnectionsOutputWidget() {
}
//-----------------------------------------------
void KBearRecentConnectionsOutputWidget::addToRecent( const SiteInfo& site ) {
	QString entry = site.parent() + "/" + site.label();
	QListViewItemIterator it( firstChild() );
	for( ; it.current(); ++it ) {
		if( it.current()->text( 0 ) == entry ) {
			static_cast<KBearRecentConnectionsItem*>( it.current() )->addReference( site.ID() );
			return;
		}
	}
	KBearRecentConnectionsItem* item = new KBearRecentConnectionsItem( m_config, this, entry );
	item->addReference( site.ID() );
	item->setExpandable( false );
}
//-----------------------------------------------
void KBearRecentConnectionsOutputWidget::removeFromRecent( const QString& site ) {
	QListViewItemIterator it( firstChild() );
	for( ; it.current(); ++it ) {
		if( it.current()->text( 0 ) == site ) {
			delete it.current();
			m_config->deleteGroup( site );
		}
	}
}
//-----------------------------------------------
void KBearRecentConnectionsOutputWidget::loadRecent() {
	clear();

	m_config->setGroup( "RecentConnections" );
	QStringList groups = m_config->readListEntry( "List" );

	for( QStringList::Iterator it = groups.begin(); it != groups.end(); ++it ) {
		m_config->setGroup( (*it) );
		KBearRecentConnectionsItem* item = new KBearRecentConnectionsItem( m_config, this, (*it) );
		item->setExpandable( false );
	}
}
//-----------------------------------------------


