/***************************************************************************
                          siteimportwidget.h  -  description
                             -------------------
    begin                : sat feb 1 2003
    copyright            : (C) 2003 by Frithjof Engel
    email                : frithjof_engel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/  

 #ifndef SITEIMPORTWIDGET_H
 #define SITEIMPORTWIDGET_H
 
 //////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qvaluelist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kservice.h>
#include <ktrader.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearsiteimportfilterpluginiface.h"

class QGridLayout;
class QVBoxLayout;
class QSpacerItem;
class KProgress;
class KPushButton;
class KListView;

using namespace KBear;
/**
  *@author Frithjof Engel
  */
 
class KBearSiteImportWidget : public QWidget {
	Q_OBJECT
public:
	KBearSiteImportWidget( QWidget *parent, const char *name = 0 );
	/** */
	~KBearSiteImportWidget();
	/** */
	void startImport( SiteImportFilterPluginIface* importPlugin, const QString& fileName );
	/** */
	QValueList<KService::Ptr>& pluginList() { return m_pluginList; }
signals:
	void importSites( const QString& );
protected slots:
	/** */
	virtual void slotImport();
	/** */
	virtual void slotSelectionChanged();
private slots:
	void slotProgress( int );
private: // private Methods
	void setupGUI();

private:
	KProgress *m_importProgress;
	KPushButton *m_importButton;
	KListView *m_filtersListView;
	QGridLayout *m_importLayout;
	QVBoxLayout *m_vboxLayout;
	QSpacerItem *m_spacer;
	QValueList<KService::Ptr> m_pluginList;
	SiteImportFilterPluginIface* m_importPlugin;
};

#endif
