/***************************************************************************
                          kbearsystemtraydock.h  -  description
                             -------------------
    begin                : mn maj 27 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARSYSTEMTRAYDOCK_H
#define KBEARSYSTEMTRAYDOCK_H

//////////////////////////////////////////////////////
// Qt specific includes
#include <qlabel.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kpopupmenu.h>
//////////////////////////////////////////////////////
// Application specific includes

class KToggleAction;
class KPopupMenu;
namespace KBear {
	class KBearAPI;
};

/**
  *@author Bjrn Sahlstrm
  */

class KBearSystemTrayDock : public QLabel  {
   Q_OBJECT
public: 
	/** */
	KBearSystemTrayDock( KBear::KBearAPI* api, QWidget* parent, const char* name );
	/** */
	~KBearSystemTrayDock();
public slots:
	/** */
	void slotSetToolTip( int active, int queued );
protected:
	void mousePressEvent( QMouseEvent * );
	/**
	Makes it easy to adjust some menu items right before the
	context menu becomes visible.
	*/
	void contextMenuAboutToShow();
	/**
	 Reimplemented for internal reasons.
	*/
	virtual void enterEvent( QEvent* );
private slots:
	void toggleMinimizeRestore();
private:
	KPopupMenu* m_menu;
	KBear::KBearAPI* m_api;
};

#endif
