/***************************************************************************
                          kbeartoolsplugin.cpp  -  description
                             -------------------
    begin                : lr mar 2 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qcursor.h>
#include <qtimer.h>
#include <qvbox.h>
#include <qpushbutton.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kiconloader.h>
#include <klocale.h>
#include <kdialogbase.h>
#include <kwizard.h>
#include <kconfig.h>
#include <kconfigbase.h>
#include <kapplication.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kdesktopfile.h>
#include <kmainwindow.h>
#include <kstatusbar.h>
#include <ktoolbar.h>
#include <kinstance.h>
#include <kgenericfactory.h>
#include <kaboutapplication.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbeartoolsplugin.h"
#include "kbeartoolswidget.h"
#include "kbearmainwiniface.h"
#include "kbearapi.h"
#include "kbearcore.h"

#include "kbeartoolsplugin.moc"

using namespace KBear;
//-----------------------------------------------
typedef KGenericFactory<KBearToolsPlugin> KBearToolsPluginFactory;
K_EXPORT_COMPONENT_FACTORY( kbeartools, KBearToolsPluginFactory( "kbeartools" ) );
//-----------------------------------------------
KBearToolsPlugin::KBearToolsPlugin(QObject *parent, const char *, const QStringList& )
	:	KBear::KBearPlugin( parent, "KBearToolsPlugin" )
{
	KGlobal::locale()->insertCatalogue("kbear");
	setInstance( KBearToolsPluginFactory::instance() );

//	kapp->config()->setGroup("MainWindow Toolbar toolsToolBar");

	setXMLFile("kbeartoolsplugin.rc");
}
//-----------------------------------------------
KBearToolsPlugin::~KBearToolsPlugin(){
}
//-----------------------------------------------
void KBearToolsPlugin::slotInit()  {
//	connect( actionCollection(), SIGNAL( actionStatusText(const QString &) ), mainWindow()->statusBar(), SLOT( message(const QString &) ) );
//	connect( actionCollection(), SIGNAL( clearStatusText() ), mainWindow()->statusBar(), SLOT( clear() ) );
	slotUpdateMenu();
}
//-----------------------------------------------
void KBearToolsPlugin::slotConfigWidget( KDialogBase* dlg ) {
	QVBox* vbox = dlg->addVBoxPage( i18n("Tools Menu"), QString::null, KGlobal::iconLoader()->loadIcon("misc", KIcon::NoGroup, KIcon::SizeMedium) );
	KBearToolsWidget* w = new KBearToolsWidget( vbox, "KBearToolsWidget" );
	connect( dlg, SIGNAL( okClicked() ), w, SLOT( slotSaveToolsList() ) );
	connect( w, SIGNAL( update() ), this, SLOT( slotUpdateMenu() ) );
}
//-----------------------------------------------
void KBearToolsPlugin::slotConfigWidget( KWizard* wiz ) {
	KBearToolsWidget* w = new KBearToolsWidget( wiz, "KBearToolsWidget" );
	wiz->addPage( w, i18n("Tools Menu") );
//	connect( wiz->finishButton(), SIGNAL( clicked() ), w, SLOT( slotSaveToolsList() ) );
	connect( w, SIGNAL( update() ), this, SLOT( slotUpdateMenu() ) );
}
//-----------------------------------------------
void KBearToolsPlugin::slotUpdateMenu() {
	QPtrList<KAction> actions;
	unplugActionList("tools_list");

	KConfigGroupSaver cs(  kapp->config(), kapp->config()->group() );
	kapp->config()->setGroup("Tools");
	QStringList list = kapp->config()->readListEntry("Tools");
	for(QStringList::Iterator it = list.begin(); it != list.end(); ++it) 	{
		QString name = *it;

		KDesktopFile df(name, true);
		if(df.readName().isNull())
			continue;

		KAction *action = new KAction(df.readName(), df.readIcon(), 0,
							this, SLOT(slotToolActivated()), actionCollection(), name.latin1());
		action->setToolTip( i18n("Open Application: %1").arg( df.readName() ) );
		action->setGroup( "list" );
		actions.append(action);
	}
	plugActionList("tools_list", actions);
}
//-----------------------------------------------
void KBearToolsPlugin::slotToolActivated() {
	QString df = sender()->name();
	int dummy = kapp->startServiceByDesktopPath(df);
	dummy = 0; // just to avoid comppiler warnings
}
//-----------------------------------------------
