/***************************************************************************
                          kbeartoolswidget.h  -  description
                             -------------------
    begin                : sn mar 3 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARTOOLSWIDGET_H
#define KBEARTOOLSWIDGET_H

//////////////////////////////////////////////////////
// Qt specific includes
#include <qwidget.h>
#include <qptrlist.h>
//////////////////////////////////////////////////////
// KDE specific includes
//////////////////////////////////////////////////////
// Application specific includes
#include "kbearconfigwidgetiface.h"

class Entry;
class TreeView;
class KListBox;
class KPushButton;

/**
  *@author Bjrn Sahlstrm
  */

class KBearToolsWidget : public KBear::KBearConfigWidgetIface  {
   Q_OBJECT
public: 
	/** */
	KBearToolsWidget(QWidget *parent=0, const char *name=0);
	/** */
	~KBearToolsWidget();
	/** */
	virtual bool helpEnabled() const { return false; }
	/** */
	virtual void readSettings( bool defaultSettings = false ) { loadToolsList(); }
	/** */
	virtual void saveSettings() { slotSaveToolsList(); }
public slots:
	/** */
	void slotEnableButtons();
	/** */
	void slotSaveToolsList();
signals:
	void update();
protected:
	/** */
	void loadToolsList();
	/** */
	void addToList(const QString &desktopFile);
protected slots:
	/** */
	virtual void slotToList();
	/** */
	virtual void slotToTree();
	/** */
	virtual void slotUp();
	/** */
	virtual void slotDown();
	/** */
	void updateList();
private:
	void setupGUI();
private:
	TreeView* m_applicationsTreeView;
	KListBox* m_toolsMenuList;
	KPushButton* m_toListButton;
	KPushButton* m_toTreeButton;
	KPushButton* m_upButton;
	KPushButton* m_downButton;
	QPtrList<Entry> m_applications;
};

#endif
