/***************************************************************************
                          kbeartransferview.cpp  -  description
                             -------------------
    begin                : lr maj 05 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


//////////////////////////////////////////////////////
// Qt specific includes
#include <qptrlist.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kconfig.h>
#include <kconfigbase.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbeartransferview.h"
#include "transferviewpage.h"
#include "transfermanager.h"
#include "transferitem.h"
#include "transfergroup.h"
#include "transfermanager.h"
#include "connectionmanager.h"

#include "kbeartransferview.moc"


using namespace KBear;
//-----------------------------------------------
KBearTransferView::KBearTransferView( KConfig* config )
	:	KBearTabView( 0L, "KBearTransferView" ),
		m_config( config )
{
	connect( TransferManager::getInstance(), SIGNAL( transferGroupAdded( int, TransferGroup* ) ),
						this, SLOT( slotAddTransferGroup( int, TransferGroup* ) ) );
	connect( ConnectionManager::getInstance(), SIGNAL( siteClosed( int ) ),
						this, SLOT( slotRemovePage( int ) ) );
}
//-----------------------------------------------
KBearTransferView::~KBearTransferView(){
}
//-----------------------------------------------
void KBearTransferView::slotAddPage( const SiteInfo& info ) {
	QString name = info.label();
	QWidget* tab = m_tabs.find( info.ID() );
	if( ! tab ) {
		TransferViewPage* w = new TransferViewPage( this, name.latin1() );
		addPage( info.ID(), w, name );
		connect( w, SIGNAL( remove( TransferViewPage* ) ), this, SLOT( slotRemovePage( TransferViewPage* ) ) );
		connect( w, SIGNAL( contextMenu( KListView*, QListViewItem*, const QPoint& ) ),
							this, SIGNAL( contextMenu( KListView*, QListViewItem*, const QPoint& ) ) );
	}
}
//-----------------------------------------------
void KBearTransferView::slotRemovePage( int ID ) {
	removePage( ID );
}
//-----------------------------------------------
void KBearTransferView::slotRemovePage( TransferViewPage* page ) {
	if( ! page )
		return;

	QIntDictIterator<QWidget> it( m_tabs );
	for( ; it.current(); ++it ) {
		if( it.current() == page ) {
			removePage( it.currentKey() );
			return;
		}
	}
}
//-----------------------------------------------
void KBearTransferView::slotAddTransferGroup( int, TransferGroup* group ) {
	if( ! group )
		return;

	QPtrList<Transfer>* transferList = group->transfers();
	if( ! transferList->isEmpty() ) {
		QString lbl;
		Transfer* transfer = transferList->first();
		if( transfer->sourceID() < 0 ) { // dest is remote
			lbl = transfer->destInfo().label();
		}
		else { // either source is remote or boths source and dest are remote
			lbl = transfer->sourceInfo().label();
		}
		kdDebug()<<k_funcinfo<<"sourceID="<<transfer->sourceID()<<" destID="<<transfer->destID()<<" lbl="<<lbl<<endl;
		int ID = findTabByCaption( lbl );
		QWidget* w = page( ID );
		if( w ) {
			TransferViewPage* page = dynamic_cast<TransferViewPage*>( w );
			page->addTransferGroup( group );
		}
	}
}
//-----------------------------------------------
void KBearTransferView::slotStart() {
	setCommand( Transfer::Start, ( Transfer::Queued | Transfer::Canceled ) );
}
//-----------------------------------------------
void KBearTransferView::slotStop() {
	setCommand( Transfer::Cancel, ( Transfer::Started | Transfer::Paused | Transfer::Queued ) );
}
//-----------------------------------------------
void KBearTransferView::slotPause() {
	setCommand( Transfer::Pause, Transfer::Started );
}
//-----------------------------------------------
void KBearTransferView::slotContinue() {
	setCommand( Transfer::Resume, Transfer::Paused );
}
//-----------------------------------------------
void KBearTransferView::setCommand( Transfer::Command command, unsigned int statusCheck ) {
	 TransferViewPage* page = dynamic_cast<TransferViewPage*>( currentPage() );
	 if( page && page->currentItem() ) {
	 	TransferItem* item = dynamic_cast<TransferItem*>( page->currentItem() );
		if( item ) {
			Transfer* transfer = item->transfer();
			if( transfer ) {
				if( transfer->status() &statusCheck ) {
					TransferManager::getInstance()->setTransferCommand( transfer->transferID(), command );
				}
			}
		}
	 }
}
//-----------------------------------------------
void KBearTransferView::slotCollapse() {
	 TransferViewPage* page = dynamic_cast<TransferViewPage*>( currentPage() );
	 if( page )
		page->setAllOpen( false );
}
//-----------------------------------------------
void KBearTransferView::slotExpand() {
	 TransferViewPage* page = dynamic_cast<TransferViewPage*>( currentPage() );
	 if( page )
		page->setAllOpen( true );
}
//-----------------------------------------------
int KBearTransferView::findTabByCaption( const QString& n ){
	for( int i = 0; i < count(); i++ ) {
		if( label( i ) == n ) {
			return i;
		}
	}
	return -1;
}
//-----------------------------------------------
