/*********************************************************************************
* C++ Interface: transferitem.h
* Description:
*
* Begin : tis jun 3 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARTRANSFERITEM_H
#define KBEARTRANSFERITEM_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
#include <qlistview.h>
#include <qguardedptr.h>
#include <qpixmap.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kurl.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files

namespace KBear {
	class Transfer;
	class TransferGroupItem;

	/**
	@author Bjrn Sahlstrm
	*/
	class TransferItem : public QObject, public QListViewItem {
			Q_OBJECT
		public:
			/** */
			TransferItem( TransferGroupItem* groupItem, Transfer* transfer );
			/** */
			TransferItem( TransferGroupItem* groupItem, QListViewItem* after, Transfer* transfer );
			/** */
			~TransferItem();
			/** */
			Transfer* transfer() const { return m_transfer; }
			/** */
			bool isHidden() const { return m_hidden; }
			/** */
			void init();
		signals:
			/** */
			void hidden();
			/** */
			void shown();
		private slots:
			void slotStatusChanged( long, unsigned int );
			void slotTransferRemoved( long ID );
			void slotProgress( long, unsigned long );
			void slotTotalFiles( long ID, unsigned long files );
			void slotProcessedFiles( long ID, unsigned long files );
			void slotTotalDirs( long ID, unsigned long dirs );
			void slotProcessedDirs( long ID, unsigned long dirs );
			void slotTotalSize( long ID, KIO::filesize_t size );
			void slotProcessedSize( long ID, KIO::filesize_t size );
			void slotSpeed( long ID, unsigned long bytes_per_sec );
			void slotCopying( long, const KURL& source, const KURL& dest );
		private:
			QGuardedPtr<Transfer> m_transfer;
			QListViewItem* m_transferTypeItem;
			QListViewItem* m_statusItem;
			QListViewItem* m_progressItem;
			QListViewItem* m_speedItem;
			QListViewItem* m_remainingTimeItem;
			QListViewItem* m_processedSizeItem;
			QListViewItem* m_totalSizeItem;
			QListViewItem* m_sourceItem;
			QListViewItem* m_destinationItem;
			QListViewItem* m_totalDirsItem;
			QListViewItem* m_totalFilesItem;
			QListViewItem* m_processedDirsItem;
			QListViewItem* m_processedFilesItem;
			static const QPixmap s_uninitializedPixmap;
			static const QPixmap s_pausedPixmap;
			static const QPixmap s_startedPixmap;
			static const QPixmap s_queuedPixmap;
			KIO::filesize_t m_totalSize;
			KIO::filesize_t m_processedSize;
			bool m_hidden;
	};

};

#endif
