/*********************************************************************************
* C++ Interface: kbeartransferqueueplugin.h
* Description:
*
* Begin : sn feb 02 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef _KBEARTRANSFERQUEUEPLUGIN_H_
#define _KBEARTRANSFERQUEUEPLUGIN_H_


//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qpoint.h>
#include <qpixmap.h>
#include <qptrlist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kaction.h>
#include <klistview.h>
#include <kio/global.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearplugin.h"
#include "transfer.h"
#include "transferqueueconfigwidget.h"

namespace KBear {
	class TransferQueueWidget;
	class TransferQueueItem;
	class TransferQueueSession;

	/**
	*
	* @author Bjrn Sahlstrm
	**/
	class KBearTransferQueuePlugin : public KBearPlugin {
			Q_OBJECT
		public:
			/** */
			KBearTransferQueuePlugin( QObject* parent, const char* name, const QStringList& args = QStringList() );
			/** */
			~KBearTransferQueuePlugin();
		public slots:
			/** */
			virtual void slotInit();
			/** */
			virtual void slotConfigWidget( KDialogBase* dlg );
			/** */
			virtual void slotConfigWidget( KWizard* wiz );
			/** */
			void slotTransferStatusChanged( TransferQueueItem* item, unsigned int status );
			/** */
			void slotProgress( TransferQueueItem* item, unsigned long progress );
			/** */
			void slotTotalSize( TransferQueueItem* item, KIO::filesize_t size );
		private slots:
			void slotStop();
			void slotStart();
			void slotQueue();
			void slotPause();
			void slotContinue();
			void slotQueueAll();
			void slotRemove();
			void slotRemoveAll();
			void slotMoveUp();
			void slotMoveDown();
			void slotSystemTrayMenuNeeded( KPopupMenu* );
			void slotQueueIsEmpty();
			void slotUpdateValues();
			void slotContextMenu( KListView*, QListViewItem*, const QPoint& );
			void slotSelectionChanged();
			void slotTransferAdded(  long, Transfer* );
			void slotRemovingTransfer( long );
//			void slotRemovingTransferGroup( int );
			void slotTransferDone( long ID );
		private:
			void updateActions( QListViewItem* item );
			bool setCommand( TransferQueueItem*, const Transfer::Command&, unsigned int );
		private:
			TransferQueueWidget* m_queueWidget;
			KAction* m_startAction;
			KAction* m_stopAction;
			KAction* m_queueAction;
			KAction* m_pauseAction;
			KAction* m_continueAction;
			KAction* m_removeAction;
			KAction* m_removeAllAction;
			KAction* m_moveUpAction;
			KAction* m_moveDownAction;
			KToggleAction* m_disconnectAction;
			KToggleAction* m_shutDownActon;
			KToggleAction* m_queueAllAction;
			bool m_sysShutdownWhenDone;
			QString m_disconnectCommand;
			QPtrList<Transfer> m_queue;
			TransferQueueSession* m_session;
			bool m_initialized;
			int m_maxNumOfActiveTransfers;
	};

};

#endif
