/*********************************************************************************
* C++ Interface: transferqueuewidget.h
* Description:
*
* Begin : tor maj 08 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef TRANSFERQUEUEWIDGET_H
#define TRANSFERQUEUEWIDGET_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qpainter.h>
#include <qpalette.h>
#include <qguardedptr.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klistview.h>
#include <kio/global.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files

namespace KBear {
	class Transfer;
	class KBearTransferQueuePlugin;

	/**
	@author Bjrn Sahlstrm
	*/
	class TransferQueueWidget : public KListView {
			Q_OBJECT
		public:
			/** */
			TransferQueueWidget( KBearTransferQueuePlugin* plugin );
			/** */
			void addTransfer( Transfer* transfer );
			/** */
			void removeTransfer( Transfer* transfer );
			/** */
			virtual void setColumnWidth( int column, int w );
		private:
			KBearTransferQueuePlugin* m_plugin;
	};
//////////////////////////////////////////////////////////////////////
	class TransferQueueItem : public QObject, public QListViewItem {
			Q_OBJECT
		public:
			/** */
			TransferQueueItem( Transfer* transfer, QListView* p, const QString& t1,
														const QString& t2, const QString& t3, const QString& t4, const QString& t5, const QString& t6 );
			/** */
			TransferQueueItem( Transfer* transfer, QListView* p, QListViewItem* after, const QString& t1,
														const QString& t2, const QString& t3, const QString& t4, const QString& t5, const QString& t6 );
			/** */
			virtual void paintCell(QPainter* p, const QColorGroup& cg, int column, int width, int align );
			/** */
			Transfer* transfer() const { return m_transfer; }
			/** */
			void connectTransfer( Transfer* transfer );
			/** */
			long ID() const;
			/** */
			void setStatus( unsigned int status );
			/** */
			void setProgress( int progress );
			/** */
			void setTotalSize( KIO::filesize_t totSize );
		signals:
			void progress( TransferQueueItem*, unsigned long );
			void totalSize( TransferQueueItem*, KIO::filesize_t size );
			void statusChanged( TransferQueueItem*, unsigned int );
		private slots:
			void slotTransferStatusChanged( long, unsigned int );
			void slotProgress( long, unsigned long );
			void slotTotalSize( long, KIO::filesize_t size );
		private:
			QGuardedPtr<Transfer> m_transfer;
			long m_ID;
			static const QPixmap s_startedPix;
			static const QPixmap s_stoppedPix;
			static const QPixmap s_queuedPix;
			static const QPixmap s_pausedPix;
			static const QPixmap s_uninitializedPix;
	};
};

#endif
