/*********************************************************************************
* C++ Implementation: kbearwizardplugin..h
* Description:
*                              
* Begin : tis jan 15 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qapplication.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kaction.h>
#include <qapplication.h>
#include <kdialogbase.h>
#include <kinstance.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kconfigbase.h>
#include <kstatusbar.h>
#include <kgenericfactory.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearwizardplugin.h"
#include "kbearmainwiniface.h"
#include "kbearpluginmanageriface.h"
#include "transfermanager.h"
#include "kbearapi.h"
#include "kbearcore.h"
#include "kbearconfigwidgetiface.h"


#include "kbearwizardplugin.moc"

using namespace KBear;
//-----------------------------------------------
typedef KGenericFactory<KBearWizardPlugin> KBearWizardPluginFactory;
K_EXPORT_COMPONENT_FACTORY( kbearwizard, KBearWizardPluginFactory( "kbearwizard" ) );
//-----------------------------------------------
KBearWizardPlugin::KBearWizardPlugin( QObject* parent, const char* , const QStringList& )
  : KBear::KBearPlugin( parent, "KBearWizardPlugin" )
{
	KGlobal::locale()->insertCatalogue("kbear");
	setInstance ( KBearWizardPluginFactory::instance() );
	setXMLFile("kbearwizardplugin.rc");
	KAction* action = new KAction( i18n("Run Application &Wizard"), "wizard", 0, this, SLOT( slotRunWizard() ), actionCollection(), "settings_wizard" );
	action->setToolTip( i18n("Run the application Wizard") );
	connect( m_api->pluginManager(), SIGNAL( pluginLoaded( KBear::KBearPlugin* ) ),
						this, SLOT( slotPluginLoaded( KBear::KBearPlugin* ) ) );
}
//-----------------------------------------------
KBearWizardPlugin::~KBearWizardPlugin() {
}
//-----------------------------------------------
void KBearWizardPlugin::slotInit()  {
//	connect( actionCollection(), SIGNAL( actionStatusText(const QString &) ), mainWindow()->statusBar(), SLOT( message(const QString &) ) );
//	connect( actionCollection(), SIGNAL( clearStatusText() ), mainWindow()->statusBar(), SLOT( clear() ) );
	checkFirstRun();
}
//-----------------------------------------------
void KBearWizardPlugin::checkFirstRun() {
	KConfig* config = kapp->config();
	KConfigGroupSaver cs( config, config->group() );
	config->setGroup("General");
	if( config->readBoolEntry( "First Run", true ) ) {
		slotRunWizard();	
	}
}
//-----------------------------------------------
void KBearWizardPlugin::slotPluginLoaded( KBear::KBearPlugin* plugin ) {
	// If a plugin is loaded when wizard is running, load it's config widget
	if( m_wizard )
		plugin->slotConfigWidget( m_wizard );
}
//-----------------------------------------------
void KBearWizardPlugin::slotRunWizard() {
	QApplication::setOverrideCursor( waitCursor );
	m_wizard = new KBearWizard( mainWindow()->mainWindow(), "KBearWizard" );

	m_api->transferManager()->slotConfigWidget( m_wizard );

	m_api->core()->emitConfigWidget( m_wizard );

	for( int i = 0; i < m_wizard->pageCount(); i++ ) {
		KBearConfigWidgetIface* w = dynamic_cast<KBearConfigWidgetIface*>( m_wizard->page( i ) );
		if( w ) { 
			m_wizard->setHelpEnabled( w->parentWidget(), w->helpEnabled() );
			w->readSettings();
		}
	}
	m_wizard->setFinishEnabled( m_wizard->KWizard::page( m_wizard->pageCount() - 1 ), true );
	QApplication::restoreOverrideCursor();
	if( m_wizard->exec() == QDialog::Accepted ) {
		for( int i = 0; i < m_wizard->pageCount(); i++ ) {
			KBearConfigWidgetIface* w = dynamic_cast<KBearConfigWidgetIface*>( m_wizard->page( i ) );
			if( w ) { 
				w->saveSettings();
				w->applySettings();
			}
		}
	}
	delete m_wizard;
}
//-----------------------------------------------
