/*********************************************************************************
* C++ Interface: uisettingswidget.h
* Description:
*
* Begin : tis mar 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/
#ifndef UISETTINGSWIDGET_H
#define UISETTINGSWIDGET_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearconfigwidgetiface.h"

class QLabel;
class QCheckBox;
class QRadioButton;

class UISettingsWidget : public KBear::KBearConfigWidgetIface {
	Q_OBJECT
public:
	/** */
	UISettingsWidget( QWidget* parent = 0, const char* name = 0 );
	/** */
	~UISettingsWidget();
	/**
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual QString helpSection() const;
	/**
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual bool helpEnabled() const { return true; }
	/**
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual void readSettings( bool defaultSettings = false );
	/** 
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual void saveSettings();
signals:
	void newSettings();
private slots:
	void slotSaveSettings() { saveSettings(); }
	void slotViewSelect();
private:
	void setupGUI();
	void setChildFrameMode( unsigned int mode );
	unsigned int getChildFrameMode();
private:;
	QLabel* m_viewTypePicture;
	QRadioButton* m_detailedView;
	QRadioButton* m_shortView;
	QRadioButton* m_topLevelRadioButton;
	QRadioButton* m_childFrameRadioButton;
	QRadioButton* m_tabPageRadioButton;
	QRadioButton* m_classicModeRadioButton;
	QCheckBox* m_rememberPosCheckBox;
	QRadioButton* m_expandHorizontal;
	QRadioButton* m_expandVertical;
	QRadioButton* m_pragmasTile;
	QRadioButton* m_tileVertically;
	QRadioButton* m_cascade;
	QRadioButton* m_cascadeMaximized;
	QRadioButton* m_maximizedChildFrameMode;
	QRadioButton* m_anodinesTile;
	QCheckBox* m_useAutoChildFrameMode;
	QCheckBox* m_childStatusBarCheckBox;
	QCheckBox* m_childToolBarCheckBox;
	QCheckBox* m_childPathToolBarCheckBox;
	QCheckBox* m_childInfoBarCheckBox;
	QCheckBox* m_treeViewCheckBox;
};

#endif // CHILDVIEWSETTINGSWIDGET_H
