/*********************************************************************************
* C++ Implementation: api.cpp
* Description:
*                              
* Begin : tis jan 15 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "api.h"
#include "core.h"
#include "connectionmanager.h"
#include "kbeartoplevel.h"
#include "transfermanager.h"
#include "kbearpartmanager.h"
#include "pluginmanager.h"


#include "api.moc"

using namespace KBear;
//-----------------------------------------------
API* API::s_instance = 0L;
//-----------------------------------------------
API::API()
	:	KBearAPI( Core::getInstance() )
{
}
//-----------------------------------------------
API::~API() {
	s_instance = 0L;
}
//-----------------------------------------------
KBearMainWindowInterface* API::mainWindow() {
	return KBearTopLevel::getInstance();
}
//-----------------------------------------------
KBearCore* API::core() {
	return Core::getInstance();
}
//-----------------------------------------------
ConnectionManager* API::connectionManager() {
	return ConnectionManager::getInstance();
}
//-----------------------------------------------
TransferManager* API::transferManager() {
	return TransferManager::getInstance();
}
//-----------------------------------------------
KBearPartManagerInterface* API::partManager() {
	return KBearPartManager::getInstance();
}
//-----------------------------------------------
KBearPluginManagerInterface* API::pluginManager() {
	return PluginManager::getInstance();
}
//-----------------------------------------------
API* API::getInstance() {

	if( ! s_instance ) {
		s_instance = new API();
//		(void)KBearTopLevel::getInstance();
		// we need to be sure the transfermanager is created.
//		(void)TransferManager::getInstance();
	}
	return s_instance;
}
//-----------------------------------------------
