/*********************************************************************************
* C++ Implementation: kbearchildview.cpp
* Description:
*
* Begin : tis mar 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARCHILDVIEW_H
#define KBEARCHILDVIEW_H

//////////////////////////////////////////////////////
// Qt specific includes
#include <qwidget.h>
#include <qlabel.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kparts/part.h>
#include <kio/jobclasses.h>
#include <kfileitem.h>
#include <kurldrag.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbearchildviewiface.h"
#include "siteinfo.h"

using namespace KBear;

class KXMLGUIClient;
class QPopupMenu;

namespace KBear {
	class KBearFileSysPartInterface;
};
/**
	* This class is an abstract class for all child views in @ref KBear.
	* It offers a DCOP interface, a toolbar and some useful information in the statusbar
	* reimplement the pure virtual functions to get the look and functionality you desire.
	* It also offers a directory tree view, @ref KBearDirVIew and a @ref KFileView
	* @see KBearDirView
	* @see KFileView
	* @see KBearDirOperator
	* @see KBearDetailView
	* @see KBearIconView
	* @see KBearDirOperator
	* @see KBear
	* @short This class is the base class for all child views in @ref KBear.
	* @author Bjrn Sahlstrm
*/

class KBearChildView : public QWidget, public KBearChildViewIface  {
   Q_OBJECT
public: 
	/** */
	KBearChildView( QWidget *parent, const SiteInfo& c );
	/** */
	~KBearChildView();
	/** */
	virtual const KFileItemList* selectedItems() const;
	/** */
	virtual const KURL::List selectedURLs() const;
	/** */
	virtual void setPath( QString path );
	/** */
	virtual void reload();
	/** */
	virtual void home();
	/** */
	virtual void cdUp();
	/** */
	virtual void back();
	/** */
	virtual void forward();
	/** */
	virtual void stop();
	/** */
	virtual QString currentURL() const;
	/** */
	virtual SiteInfo siteInfo() const { return m_siteInfo; }
	/** */
	virtual bool isLocal() const;
	/** */
	KBearFileSysPartInterface* part() const { return m_part; }
	/** */
	virtual void readProperties( KConfig* config, const QString& group );
	/** */
	virtual void saveProperties( KConfig* config, const QString& group );
	/**
	* @return the view specific popup menu
	*/
	QPopupMenu* popupMenu();
protected:
	/**
	* If attached, the childframe will be activated and the MDI taskbar button will be pressed. Additionally, the
	* memorized old focused child widget of this is focused again.
	* Sends the focusInEventOccurs signal befor changing the focus and the
	* gotFocus signal after changing the focus.
	*/
//	virtual void focusInEvent(QFocusEvent *e);
signals:
	/** */
	void selectionChanged();
	/** */
	void closeMe();
private slots:
	void slotClientAdded( KXMLGUIClient* client );
	void slotInit();
private:
	SiteInfo m_siteInfo;
	KBearFileSysPartInterface* m_part;

};

#endif

