/*********************************************************************************
* C++ Interface: kbearclassicmainwindow.h
* Description:
*
* Begin : mn mar 24 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARCLASSICMAINWINDOW_H
#define KBEARCLASSICMAINWINDOW_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qptrlist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kparts/dockmainwindow.h>
#include <kdockwidget.h>
#include <kaction.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearmainwiniface.h"
#include "miscsettingswidget.h"
#include "api.h"
#include "siteinfo.h"
#include "kbearmainwindowshared.h"

/**
 * 
 * Bjrn Sahlstrm
 **/
using namespace KBear;

class QSplitter;
class KPushButton;
class KBearOutputToolBar;
class QPopupMenu;
class KBearChildView;

class KBearClassicMainWindow : public KParts::DockMainWindow, public KBearMainWindowInterface {
	Q_OBJECT
	friend class KBearMainWindowShared;
public:
	/**  */
	KBearClassicMainWindow();
	/**  */
	~KBearClassicMainWindow();
	/** */
	virtual void embedOutputPluginView( QWidget* view, const QString& title, const QString& toolTip );
	/** */
	virtual void removeOutputPluginView( QWidget *view );
	/** */
	virtual void raiseView(QWidget *view);
	/** */
	virtual KParts::DockMainWindow* mainWindow();
	/** */
	virtual void setLocalPath( const QString& );
	/** */
	virtual void realClose();
	/** */
	virtual void closeCurrentView();
	/** */
	virtual void closeAll();
	/** */
	virtual const KBearChildViewIface* getCurrentView();
	/** */
	virtual const KBearChildViewIface* getLocalView();
	/** */
	virtual void init();
	/** */
	virtual KBearCore* core()
				{ return API::getInstance()->core(); }
	/** */
	virtual KBearAPI* api()
				{ return API::getInstance(); }
	/** */
	virtual KBearConfigWidgetIface* miscSettingsWidget()
				{ return MiscSettingsWidget::getInstance(); }
	/** */
	virtual void raiseMainWindow();
	/** @return reference to the current childView */
	virtual DCOPRef currentChildView();
	/**  */
	virtual bool queryClose();
	/** */
	virtual void readViewSettings();
	/** */
	virtual void applyUISettings();
	/** */
	virtual void showViewLocal();
	/**
	* This method is called when it is time for the app to save its
	* properties for session management purposes.
	*/
	virtual void saveProperties( KConfig* );
	/**
	* This method is called when this app is restored.  The KConfig
	* object points to the session management config file that was saved
	* with @ref saveProperties
	*/
	virtual void readProperties( KConfig* );
	/** */
	virtual QPtrList<KBearChildViewIface> childViews();
public slots:
	/**  Update of the window menu contents. */
	virtual void fillWindowMenu();
protected slots:
	/** */
	void createGUI( KParts::Part* part );
private slots:
	void slotClose();
	void slotCloseChildView();
	void slotClickedInWindowMenu();
	void slotSelectionChanged();
	void slotTransferButtonClicked();
private:
	void initViewLocal();
	virtual KBearChildViewIface* createClient( const SiteInfo& info, const QString& whatsThis );
private:
	void setupGUI();
	QSplitter* m_splitter;
	QWidget* m_buttonWidget;
	KDockTabGroup* m_leftView;
	KDockTabGroup* m_rightView;
	KPushButton* m_toRemoteButton;
	KPushButton* m_toLocalButton;
	KBearOutputToolBar* m_outputToolBar;
	KDockWidget* m_mainDockBase;
	bool m_isClosing;
	KBearMainWindowShared* m_shared;
	QPtrList<KAction> m_windowListActions;
	QPopupMenu* m_pWindowMenu;
	KBearChildView* m_viewLocal;
	QString m_viewLocalCaption;
};

#endif
