/*********************************************************************************
* C++ Implementation: kbearmainwindowshared.cpp
* Description:
*
* Begin : mn mar 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qpopupmenu.h>
#include <qfile.h>
#include <qvbox.h>
#include <qguardedptr.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kconfig.h>
#include <kconfigbase.h>
#include <kkeydialog.h>
#include <kxmlguiclient.h>
#include <kxmlguifactory.h>
#include <kwizard.h>
#include <kapplication.h>
#include <kmenubar.h>
#include <kglobal.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kedittoolbar.h>
#include <kstatusbar.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearmainwindowshared.h"
#include "kbearchildview.h"
#include "uisettingswidget.h"
#include "miscsettingswidget.h"
#include "kbearoutputtoolbar.h"
#include "transfermanager.h"
#include "kbearquickconnectdlg.h"
#include "api.h"
#include "core.h"
#include "misc.h"
#include "kbearmainwiniface.h"
#include "kbearfilesyspartiface.h"
#include "resource.h"

using namespace KBear;

#include "kbearmainwindowshared.moc"

class KBearMainWindowShared::KBearMainWindowSharedPrivate {
	public:
		~KBearMainWindowSharedPrivate() {
			delete m_outputToolBar;
		}
		KParts::DockMainWindow* m_mainWindow;
		KBearOutputToolBar* m_outputToolBar;
		unsigned int m_transferMode;
};
//-----------------------------------------------
KBearMainWindowShared::KBearMainWindowShared( KParts::DockMainWindow* parent )
	:	QObject( parent, "KBearMainWindowShared" )
{
	d = new KBearMainWindowSharedPrivate();
	d->m_mainWindow = parent;
	d->m_outputToolBar = 0L;
	d->m_transferMode = KBear::Binary;
	setupActions();
	slotSetupTransferModeMenu( TransferManager::getInstance()->transferMode() );
}
//-----------------------------------------------
KBearMainWindowShared::~KBearMainWindowShared() {
	delete Core::getInstance();
	delete d;
}
//-----------------------------------------------
void KBearMainWindowShared::createOutputToolbar( KDockWidget* dock ) {
	d->m_outputToolBar = new KBearOutputToolBar( d->m_mainWindow, dock );
}
//-----------------------------------------------
void KBearMainWindowShared::init() {
/*
	d->m_outputToolBar->setFullSize( true );
	d->m_outputToolBar->setNewLine( true );
	d->m_outputToolBar->enableMoving( false );
	d->m_outputToolBar->setEnableContextMenu( false );
*/
	connect( API::getInstance()->core(), SIGNAL(configWidget(KWizard*)), this, SLOT(slotConfigWidget(KWizard*)) );
	connect( API::getInstance()->transferManager(), SIGNAL(transferModeChanged( unsigned int )),
						this, SLOT(slotSetupTransferModeMenu( unsigned int ) ) );
	connect( API::getInstance()->transferManager(), SIGNAL(configChanged()), this, SLOT(slotSetupTransferModeMenu() ) );
	connect( d->m_mainWindow->actionCollection(), SIGNAL( actionStatusText(const QString &) ),
					d->m_mainWindow->statusBar(), SLOT( message(const QString &) ) );
	connect( d->m_mainWindow->actionCollection(), SIGNAL( clearStatusText() ), d->m_mainWindow->statusBar(), SLOT( clear() ) );

	d->m_mainWindow->makeDockInvisible( d->m_outputToolBar->outputFrame() );

}
//-----------------------------------------------
void KBearMainWindowShared::slotSetupTransferModeMenu() {
	KConfigGroupSaver cs( kapp->config(), kapp->config()->group()   );
	kapp->config()->setGroup( QString::fromLatin1("TransferManager" ) );
	slotSetupTransferModeMenu( kapp->config()->readUnsignedNumEntry("TransferMode", KBear::Binary ) );
}
//-----------------------------------------------
void KBearMainWindowShared::slotSetupTransferModeMenu( unsigned int mode ) {
	d->m_transferMode = mode;
	switch( d->m_transferMode ) {
		case KBear::Ascii:
			slotSetAsciiMode();
			break;
		case KBear::Auto:
			slotSetAutoMode();
			break;
		default:
			slotSetBinaryMode();
	}
}
//-----------------------------------------------
void KBearMainWindowShared::embedOutputPluginView( QWidget* view, const QString& name, const QString& toolTip ) {
	if( ! d->m_outputToolBar || ! view )
		return;
	d->m_outputToolBar->addWidget( view, name, toolTip );
}
//-----------------------------------------------
void KBearMainWindowShared::removeOutputPluginView( QWidget* view ) {
	if( ! d->m_outputToolBar || ! view )
		return;
	d->m_outputToolBar->removeWidget( view );
}
//-----------------------------------------------
void KBearMainWindowShared::saveProperties( KConfig* config ) {
	QString group = config->group();
	KConfigGroupSaver cs( config, group.isEmpty() ? "General": group   );
	config->setGroup( "TransferManager" );
	config->writeEntry("TransferMode", d->m_transferMode );
	config->setGroup( "View Settings" );
	KToggleAction* action = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("show_child_toolbar"));
	config->writeEntry( "Child ToolBar", action->isChecked() );
	action = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("show_child_path_toolbar"));
	config->writeEntry( "Child Path ToolBar", action->isChecked() );
	action = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("show_child_statusbar"));
	config->writeEntry( "Child StatusBar", action->isChecked() );
	action = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("show_child_infobar"));
	config->writeEntry( "Child InfoBar", action->isChecked() );
	config->setGroup( "MainWindow" );
	action = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("view_fullscreen"));
	config->writeEntry( "FullScreen", action->isChecked() );
	config->sync();
}
//-----------------------------------------------
void KBearMainWindowShared::readProperties( KConfig* config ) {
	QString group = config->group();
	KConfigGroupSaver cs( config, group.isEmpty() ? "General": group   );
	config->setGroup( "General" );
	double version = config->readDoubleNumEntry( "Version" );
	if( version < IDS_VERSION ) { // if older version we have to remove the old config file
		QString file = locateLocal( "config", "kbearrc" );
		if( QFile::exists( file ) ) {
			QFile f( file );
			f.remove();
		}
		config->writeEntry( "Version", IDS_VERSION );
		config->sync();
		config->reparseConfiguration();
	}

	config->setGroup( "View Options" );
	KToggleAction* act = static_cast<KToggleAction*>( d->m_mainWindow->actionCollection()->action("show_local"));
	act->setChecked( config->readBoolEntry( "Show Local", true ) );

	kapp->config()->setGroup( "View Settings" );
	act = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("show_child_toolbar"));
	act->setChecked( kapp->config()->readBoolEntry( "Child ToolBar", true ) );
	act = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("show_child_path_toolbar"));
	act->setChecked( kapp->config()->readBoolEntry( "Child Path ToolBar", true ) );
	act = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("show_child_statusbar"));
	act->setChecked( kapp->config()->readBoolEntry( "Child StatusBar", true ) );
	act = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("show_child_infobar"));
	act->setChecked( kapp->config()->readBoolEntry( "Child InfoBar", true ) );
	config->setGroup( "MainWindow" );
	act = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("view_fullscreen"));
	act->setChecked( kapp->config()->readBoolEntry( "FullScreen", false ) );

	slotShowFullScreen();
}
//-----------------------------------------------
void KBearMainWindowShared::setupActions() {
	//FTP menu
	KAction* action = KStdAction::openNew( this, SLOT( slotQuickConnect() ), d->m_mainWindow->actionCollection(), "quick_connect" );
	action->setText( i18n("Quick &Connect") );
	action->setIcon( "connect_creating" );
	action->setToolTip( i18n("Open the Quick connect dialog")  );
	action = KStdAction::close( this, SLOT( slotDisconnect() ), d->m_mainWindow->actionCollection(), "close_connection" );
	action->setText( i18n("C&lose Connection") );
	action->setIcon( "connect_no" );
	KStdAction::quit( this, SLOT( slotQuit() ), d->m_mainWindow->actionCollection(), KStdAction::name(KStdAction::Quit) );

	// Transfer mode menuBar
	KRadioAction* radioAction = new KRadioAction( i18n("&Binary"), 0, this, SLOT( slotSetBinaryMode() ), d->m_mainWindow->actionCollection(), "transfer_mode_binary" );
	radioAction->setExclusiveGroup( "transfermode" );
	radioAction = new KRadioAction( i18n("&Ascii"), 0, this, SLOT( slotSetAsciiMode() ), d->m_mainWindow->actionCollection(), "transfer_mode_ascii" );
	radioAction->setExclusiveGroup( "transfermode" );
	radioAction = new KRadioAction( i18n("A&uto"), 0, this, SLOT( slotSetAutoMode() ), d->m_mainWindow->actionCollection(), "transfer_mode_auto" );
	radioAction->setExclusiveGroup( "transfermode" );

	// View menu
	new KToggleAction( i18n("Full-Screen Mode"), "window_fullscreen", CTRL+SHIFT+Key_F, this, SLOT( slotShowFullScreen() ), d->m_mainWindow->actionCollection(), "view_fullscreen" );

	// Settings menu
	KStdAction::showMenubar(this, SLOT(slotOptionsShowMenubar()), d->m_mainWindow->actionCollection(), KStdAction::name(KStdAction::ShowMenubar ) );
	KStdAction::showStatusbar(this, SLOT(slotOptionsShowStatusbar()), d->m_mainWindow->actionCollection(), KStdAction::name(KStdAction::ShowStatusbar ) );
	new KToggleAction( i18n("Show Your &Local Filesystem"), 0, this, SLOT( slotOptionsShowViewLocal() ), d->m_mainWindow->actionCollection(), "show_local" );
	KStdAction::saveOptions(this, SLOT(slotOptionsSaveOptions()), d->m_mainWindow->actionCollection(), KStdAction::name(KStdAction::SaveOptions) );
	KStdAction::keyBindings(this, SLOT(slotOptionsConfigureKeys()), d->m_mainWindow->actionCollection(), KStdAction::name(KStdAction::KeyBindings) );
	KStdAction::configureToolbars(this, SLOT(slotOptionsConfigureToolbars()), d->m_mainWindow->actionCollection(), KStdAction::name(KStdAction::ConfigureToolbars));
	KStdAction::preferences(this, SLOT( slotOptionsSettings() ), d->m_mainWindow->actionCollection(), KStdAction::name(KStdAction::Preferences));

	// Settings menu
	new KToggleAction( i18n("Show &Toolbar"), 0, this, SLOT( slotOptionsShowChildToolBar() ), d->m_mainWindow->actionCollection(), "show_child_toolbar" );
	new KToggleAction( i18n("Show &Path Toolbar"), 0, this, SLOT( slotOptionsShowChildPathToolBar() ), d->m_mainWindow->actionCollection(), "show_child_path_toolbar" );
	new KToggleAction( i18n("Show &Statusbar"), 0, this, SLOT( slotOptionsShowChildStatusBar() ), d->m_mainWindow->actionCollection(), "show_child_statusbar" );
	new KToggleAction( i18n("Show &Infobar"), 0, this, SLOT( slotOptionsShowChildInfoBar() ), d->m_mainWindow->actionCollection(), "show_child_infobar" );

	// Window menu
	new KAction( i18n("&Close"), 0, this, SLOT( closeActiveView() ), d->m_mainWindow->actionCollection(), "window_close" );
	new KAction( i18n("Close &All"), 0, this, SLOT( closeAllViews() ), d->m_mainWindow->actionCollection(), "window_close_all" );


}
//-----------------------------------------------
void KBearMainWindowShared::setupToolTips(){
// setup tooltips
	d->m_mainWindow->actionCollection()->action( "quick_connect" )->setToolTip( i18n("Open the Quick connect dialog") );
	d->m_mainWindow->actionCollection()->action( "close_connection" )->setToolTip( i18n("Close connection in active window") );
	d->m_mainWindow->actionCollection()->action( KStdAction::name(KStdAction::Quit) )->setToolTip( i18n("Quit the application") );
	d->m_mainWindow->actionCollection()->action( KStdAction::name(KStdAction::ShowStatusbar) )->setToolTip( i18n("Toggle statusbar...") );
	d->m_mainWindow->actionCollection()->action( "show_local" )->setToolTip( i18n("Toggle the local file system window...") );

	d->m_mainWindow->actionCollection()->action( "show_child_toolbar" )->setToolTip( i18n("Toggle the childs toolbar...") );
	d->m_mainWindow->actionCollection()->action( "show_child_path_toolbar" )->setToolTip( i18n("Toggle the childs path toolbar...") );
	d->m_mainWindow->actionCollection()->action( "show_child_statusbar" )->setToolTip( i18n("Toggle the childs statusbar...") );
	d->m_mainWindow->actionCollection()->action( "show_child_infobar" )->setToolTip( i18n("Toggle the childs infobar...") );

	d->m_mainWindow->actionCollection()->action( KStdAction::name(KStdAction::HelpContents) )->setToolTip( i18n("Open the 'KBear Handbook.") );
	d->m_mainWindow->actionCollection()->action( KStdAction::name(KStdAction::WhatsThis) )->setToolTip( i18n("Switch to 'Whats this' mode.") );

// setup whats this
	d->m_mainWindow->actionCollection()->action( "quick_connect" )->setWhatsThis( i18n("Push this button to open a new connection.\n"
                  "You can also select the 'Quick Connect' command from the 'FTP' menu.") );
	d->m_mainWindow->actionCollection()->action( "close_connection" )->setWhatsThis( i18n("Push this button to close the active connection.\n"
                  "You can also select the 'Close Connection' command from the 'FTP' menu.") );
	d->m_mainWindow->actionCollection()->action( KStdAction::name(KStdAction::Quit) )->setWhatsThis( i18n("Push this button to quit the application.\n"
				"You can also select the 'Quit' command from the 'FTP' menu.") );
	d->m_mainWindow->actionCollection()->action( KStdAction::name(KStdAction::HelpContents) )->setWhatsThis( i18n("Push this button to open the 'KBear Handbook'.\n"
				"You can also select the 'KBear Handbook' command from the 'Help' menu.") );
}
//-----------------------------------------------
void KBearMainWindowShared::slotOptionsShowChildToolBar(){
	KToggleAction* action = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("show_child_toolbar"));
	d->m_mainWindow->statusBar()->message( action->toolTip(), 2000 );
	QPtrList<KBearChildViewIface> childViews = API::getInstance()->mainWindow()->childViews();
	for(KBearChildViewIface* w = childViews.first(); w; w= childViews.next() ) {
		static_cast<KBearChildView*>( w )->part()->showToolBarUpper( action->isChecked() );
	}
}
//-----------------------------------------------
void KBearMainWindowShared::slotOptionsShowChildPathToolBar(){
	KToggleAction* action = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("show_child_path_toolbar"));
	d->m_mainWindow->statusBar()->message( action->toolTip(), 2000 );
	QPtrList<KBearChildViewIface> childViews = API::getInstance()->mainWindow()->childViews();
	for(KBearChildViewIface* w = childViews.first(); w; w= childViews.next() ) {
		static_cast<KBearChildView*>( w )->part()->showToolBarLower( action->isChecked() );
	}
}
//-----------------------------------------------
void KBearMainWindowShared::slotOptionsShowChildStatusBar(){
	KToggleAction* action = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("show_child_statusbar"));
	d->m_mainWindow->statusBar()->message( action->toolTip(), 2000 );
	QPtrList<KBearChildViewIface> childViews = API::getInstance()->mainWindow()->childViews();
	for(KBearChildViewIface* w = childViews.first(); w; w= childViews.next() ) {
		static_cast<KBearChildView*>( w )->part()->showStatusBarUpper( action->isChecked() );
	}
}
//-----------------------------------------------
void KBearMainWindowShared::slotOptionsShowChildInfoBar(){
	KToggleAction* action = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action("show_child_infobar"));
	d->m_mainWindow->statusBar()->message( action->toolTip(), 2000 );

	QPtrList<KBearChildViewIface> childViews = API::getInstance()->mainWindow()->childViews();
	for(KBearChildViewIface* w = childViews.first(); w; w= childViews.next() ) {
		static_cast<KBearChildView*>( w )->part()->showStatusBarLower( action->isChecked() );
	}
}
//-----------------------------------------------
void KBearMainWindowShared::slotApplyUISettings() {
	API::getInstance()->mainWindow()->applyUISettings();
}
//-----------------------------------------------
void KBearMainWindowShared::slotApplyMiscSettings() {
	//TODO anything to do here ?
}
//-----------------------------------------------
void KBearMainWindowShared::slotOptionsSettings() {
	QApplication::setOverrideCursor( waitCursor );
	KDialogBase dlg( KDialogBase::IconList, i18n("Customize KBear"),
									KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, d->m_mainWindow, "customization dialog");

	dlg.setShowIconsInTreeList( true );
	dlg.setTreeListAutoResize( true );

	QVBox* vbox = dlg.addVBoxPage(i18n("User Interface"), QString::null,
								KGlobal::iconLoader()->loadIcon("view_choose", KIcon::NoGroup, KIcon::SizeMedium));
	int UIWidgetIndex = dlg.pageIndex( vbox );
	UISettingsWidget* UIWidget = new UISettingsWidget( vbox, "UISettingsWidget" );
	connect( &dlg, SIGNAL( okClicked() ), UIWidget, SLOT( slotSaveSettings() ) );
	connect( UIWidget, SIGNAL( newSettings() ), this, SLOT( slotApplyUISettings() ) );

	vbox = dlg.addVBoxPage(i18n("Miscellaneous"), QString::null,
								KGlobal::iconLoader()->loadIcon("gear", KIcon::NoGroup, KIcon::SizeMedium));
	MiscSettingsWidget* miscWidget = new MiscSettingsWidget( vbox, "MiscSettingsWidget" );
	connect( &dlg, SIGNAL( okClicked() ), miscWidget, SLOT( slotSaveSettings() ) );
	connect( miscWidget, SIGNAL( newSettings() ), this, SLOT( slotApplyMiscSettings() ) );

	API::getInstance()->transferManager()->slotConfigWidget( &dlg );

	API::getInstance()->core()->emitConfigWidget( &dlg );

	dlg.showPage( UIWidgetIndex );
	dlg.adjustSize();
	QApplication::restoreOverrideCursor();
	if( dlg.exec() == QDialog::Accepted ) {
		API::getInstance()->mainWindow()->readViewSettings();
		readProperties( kapp->config() );
	}

}
//-----------------------------------------------
void KBearMainWindowShared::slotQuit() {
	d->m_mainWindow->statusBar()->message(i18n("Exiting application..."), 2000 );
	// exits the Application
	d->m_mainWindow->close();
}
//-----------------------------------------------
void KBearMainWindowShared::slotQuickConnect() {
	d->m_mainWindow->statusBar()->message(i18n("Opening new connection..."), 2000 );
	KBearQuickConnectDlg dlg( d->m_mainWindow,"QuickConnect");
	connect( &dlg, SIGNAL( openSite( const SiteInfo& ) ), API::getInstance()->core(), SLOT( openSite( const SiteInfo& ) ) );
	dlg.exec();
}
//-----------------------------------------------
void KBearMainWindowShared::slotDisconnect() {
	API::getInstance()->mainWindow()->closeCurrentView();
}
//-----------------------------------------------
void KBearMainWindowShared::slotConfigWidget( KWizard* wiz ) {
	UISettingsWidget* UIWidget = new UISettingsWidget( wiz, "UISettingsWidget" );
	wiz->addPage( UIWidget, i18n("User Interface") );
	connect( UIWidget, SIGNAL( newSettings() ), this, SLOT( slotApplyUISettings() ) );

	MiscSettingsWidget* miscWidget = new MiscSettingsWidget( wiz, "MiscSettingsWidget" );
	wiz->addPage( miscWidget, i18n("Miscellaneous") );
	connect( miscWidget, SIGNAL( newSettings() ), this, SLOT( slotApplyMiscSettings() ) );
}
//-----------------------------------------------
void KBearMainWindowShared::slotOptionsConfigureKeys() {
	KKeyDialog dlg( true, d->m_mainWindow );
	dlg.insert( d->m_mainWindow->actionCollection() );
	QPtrList<KXMLGUIClient> clients( d->m_mainWindow->guiFactory()->clients() );
	clients.setAutoDelete( false );
	KXMLGUIClient* client;
	for( client = clients.first(); client; client = clients.next() )
		dlg.insert( client->actionCollection() );

	if( dlg.configure( true ) ) {
		kdDebug()<<"KBear::slotOptionsConfigureKeys() new config"<<endl;

		for( client = clients.first(); client; client = clients.next() )
			client->reloadXML();

//		d->m_mainWindow->createGUI( 0L );
//		createGUI( API::getInstance()->partManager()->activePart() );
	}
}
//-----------------------------------------------
void KBearMainWindowShared::slotOptionsConfigureToolbars() {
	d->m_mainWindow->saveMainWindowSettings( kapp->config(), "MainWindow" );
	// use the standard toolbar editor
	KEditToolbar dlg( d->m_mainWindow->guiFactory(), d->m_mainWindow, "ToolBarConfig" );
	connect( &dlg, SIGNAL( newToolbarConfig() ), this, SLOT( slotNewToolbarConfig() ) );
	dlg.exec();
}
//-----------------------------------------------
void KBearMainWindowShared::slotNewToolbarConfig() {
	d->m_mainWindow->applyMainWindowSettings( kapp->config(), "MainWindow" );
	API::getInstance()->core()->emitNewToolbarConfig();
}
//-----------------------------------------------
void KBearMainWindowShared::slotOptionsSaveOptions() {
	API::getInstance()->mainWindow()->saveProperties( kapp->config() );
}
//-----------------------------------------------
void KBearMainWindowShared::slotOptionsShowMenubar() {
	KToggleAction* action = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action( KStdAction::name(KStdAction::ShowMenubar) ));
	if(action->isChecked())
		d->m_mainWindow->menuBar()->show();
	else
		d->m_mainWindow->menuBar()->hide();
}
//-----------------------------------------------
void KBearMainWindowShared::slotOptionsShowStatusbar() {
	KToggleAction* action = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action( KStdAction::name(KStdAction::ShowStatusbar) ));
	if(action->isChecked())
		d->m_mainWindow->statusBar()->show();
	else
		d->m_mainWindow->statusBar()->hide();
}
//-----------------------------------------------
void KBearMainWindowShared::slotOptionsShowViewLocal() {
	API::getInstance()->mainWindow()->showViewLocal();
}
//-----------------------------------------------
void KBearMainWindowShared::slotSetBinaryMode() {
	d->m_transferMode = KBear::Binary;
	KRadioAction* act = static_cast<KRadioAction*>( d->m_mainWindow->actionCollection()->action( "transfer_mode_binary" ));
	if( act && ! act->isChecked() ) {
		act->setChecked( true );
		TransferManager::getInstance()->setTransferMode( d->m_transferMode );
	}
}
//-----------------------------------------------
void KBearMainWindowShared::slotSetAsciiMode() {
	d->m_transferMode = KBear::Ascii;
	KRadioAction* act = static_cast<KRadioAction*>( d->m_mainWindow->actionCollection()->action( "transfer_mode_ascii" ));
	if( act && ! act->isChecked() ) {
		act->setChecked( true );
		TransferManager::getInstance()->setTransferMode( d->m_transferMode );
	}
}
//-----------------------------------------------
void KBearMainWindowShared::slotSetAutoMode() {
	d->m_transferMode = KBear::Auto;
	KRadioAction* act = static_cast<KRadioAction*>( d->m_mainWindow->actionCollection()->action( "transfer_mode_auto" ));
	if( act && ! act->isChecked() ) {
		act->setChecked( true );
		TransferManager::getInstance()->setTransferMode( d->m_transferMode );
	}
}
//-----------------------------------------------
void KBearMainWindowShared::closeActiveView() {
	API::getInstance()->mainWindow()->closeCurrentView();
}
//-----------------------------------------------
void KBearMainWindowShared::closeAllViews() {
	API::getInstance()->mainWindow()->closeAll();
}
//-----------------------------------------------
KBearOutputToolBar* KBearMainWindowShared::outputToolBar() {
	return d->m_outputToolBar;
}
//-----------------------------------------------
void KBearMainWindowShared::slotShowFullScreen() {
	KToggleAction* action = static_cast<KToggleAction*>(d->m_mainWindow->actionCollection()->action( "view_fullscreen" ));
	if( action->isChecked() ) {
		action->setIcon( "window_nofullscreen" );
		d->m_mainWindow->showFullScreen();
	}
	else {
		action->setIcon( "window_fullscreen" );
		d->m_mainWindow->showNormal();
	}
}
//-----------------------------------------------

