/*********************************************************************************
* C++ Interface: kbearoutputframe.h
* Description:
*                              
* Begin : mn jan 20 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEAROUTPUTFRAME_H
#define KBEAROUTPUTFRAME_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qlabel.h>
#include <qmap.h>
#include <qintdict.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kdockwidget.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files

class QToolButton;
class QWidgetStack;
class KBearOutputFrameHeader;
namespace KParts {
	class DockMainWindow;
};
 

/**
 * 
 * @author Bjrn Sahlstrm
 **/
class KBearOutputFrame : public KDockWidget {
	Q_OBJECT
public:
	/** */
	KBearOutputFrame( KParts::DockMainWindow* mainWin, KDockWidget* dockTarget );
	/** */
	~KBearOutputFrame();
	/** */
	void addWidget( QWidget* view, const QString& title, int  index );
	/** */
	int removeWidget( QWidget* view );
	/** */
	void setActiveIndex( int index );
signals:
	/** */
	void closeButtonClicked();
	/** */
	void newVisibleWidget( int index );
private:
	int getWidgetIndex( QWidget* widget );
private:
	QWidgetStack* m_stack;
	QMap<int, QString> m_titleDict;
	KBearOutputFrameHeader* m_title;
	QIntDict<QWidget> m_widgets;
};
/**
 *
 * @author Bjrn Sahlstrm
 **/
class KBearOutputFrameHeader : public KDockWidgetAbstractHeader {
	Q_OBJECT
public:
	/** */
	KBearOutputFrameHeader( KBearOutputFrame* parent );
	/** */
	~KBearOutputFrameHeader();
	/** */
	QString title() const { return m_title->text(); }
	/** */
	void setTitle( const QString& title ) { m_title->setText( title ); }
signals:
	/** */
	void closeButtonClicked();
private:
	QToolButton* m_closeButton;
	QLabel* m_title;
};

#endif
