/*********************************************************************************
* C++ Implementation: kbearoutputtoolbar.cpp
* Description:
*                              
* Begin : mn jan 20 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qsizepolicy.h>
#include <qlayout.h>
#include <qsignalmapper.h>
#include <qintdict.h>
#include <qlabel.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kapplication.h>
#include <kparts/dockmainwindow.h>
#include <kdockwidget.h>
#include <klocale.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearoutputtoolbar.h"
#include "kbearoutputframe.h"
#include "kbearmainwindow.h"
#include "api.h"


#include "kbearoutputtoolbar.moc"

using namespace KBear;
//-----------------------------------------------
// class KBearOutputToolBar
//-----------------------------------------------
KBearOutputToolBarButton::KBearOutputToolBarButton( const QString& text, QWidget* parent, const char* name )
	:	QPushButton( text, parent, name )
{
	setFixedHeight( fontMetrics().height()+2);
	setFlat( true );
	setToggleButton(true);
	setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));
}
//-----------------------------------------------
KBearOutputToolBarButton::~KBearOutputToolBarButton() {
}
//-----------------------------------------------
QSize KBearOutputToolBarButton::sizeHint () const {
	int w = fontMetrics().width(text()) + 2*fontMetrics().width('m');
	return QSize( w, fontMetrics().height()+2 );
}
//-----------------------------------------------
// class KBearOutputToolBar
//-----------------------------------------------
KBearOutputToolBar::KBearOutputToolBar( KParts::DockMainWindow* mainWin, KDockWidget* dockTarget )
	:	KToolBar( mainWin, QMainWindow::Bottom, true, "outputToolBar", false, true ),
//	:	QToolBar( mainWin, "outputToolBar" ),
		m_stretch( 0L )
{
//	boxLayout()->setDirection( QBoxLayout::RightToLeft );
	boxLayout()->setSpacing( 2 );

	setBarPos( KToolBar::Bottom );
	positionYourself( true );

	setMovingEnabled( true );
	setFullSize( true );
	setEnableContextMenu( false );

//	mainWin->moveDockWindow( this, DockBottom );


	m_buttons.setAutoDelete( true );
	m_count = 0;
	m_selected = -1;

	m_popup = new KBearOutputFrame( mainWin, dockTarget );
	connect( m_popup, SIGNAL(closeButtonClicked() ), this, SLOT( slotCloseButtonClicked() ) );
	connect( m_popup, SIGNAL( newVisibleWidget( int ) ), this, SLOT( slotNewVisibleWidget( int ) ) );

	m_clickedMapper = new QSignalMapper( this );
	connect( m_clickedMapper, SIGNAL( mapped( int ) ), this, SLOT( slotClicked( int ) ) );
	
}
//-----------------------------------------------
KBearOutputToolBar::~KBearOutputToolBar() {
	delete m_popup;
	delete m_clickedMapper;
}
//-----------------------------------------------
KDockWidget* KBearOutputToolBar::outputFrame() {
	return m_popup ? m_popup : 0L;
}
//-----------------------------------------------
void KBearOutputToolBar::removeWidget( QWidget* widget ) {
	if( ! widget )
		return;
	int index = m_popup->removeWidget( widget );
	if( index >= 0 ) {
		m_buttons.remove( index );
	}
	if (m_buttons.count() == 0) {
		if( m_stretch ) {
			delete m_stretch;
			m_stretch = 0L;
		}
	}
}
//-----------------------------------------------
void KBearOutputToolBar::addWidget( QWidget* widget, const QString& name, const QString& toolTip ) {
	int index = m_count++;

	if( m_stretch) {
		delete m_stretch;
		m_stretch = 0L;
		setStretchableWidget( 0L);
	}

	m_popup ->addWidget( widget, name, index );

	QPushButton* button = new KBearOutputToolBarButton( name, this, name.latin1() );
	m_buttons.insert( index, button );

	setFixedHeight( button->fontMetrics().height()+10 );
	boxLayout()->addWidget( button );

//	button->show();

	m_stretch = new QLabel(this, "empty");
	m_stretch->setText("");
	boxLayout()->addWidget( button, 20 );
	setStretchableWidget( m_stretch);
//	m_stretch->show();

	QToolTip::add( button, toolTip );
	m_clickedMapper->setMapping( button, index );


	connect( button, SIGNAL( clicked() ), m_clickedMapper, SLOT( map() ) );
	connect( widget, SIGNAL( destroyed() ), this, SLOT( slotWidgetDeleted() ) );
}
//-----------------------------------------------
void KBearOutputToolBar::slotCloseButtonClicked() {
	unSelect();
}
//-----------------------------------------------
void KBearOutputToolBar::slotWidgetDeleted() {
	QWidget* w = (QWidget*) sender();
	if( w )
		removeWidget( w );
}
//-----------------------------------------------
void KBearOutputToolBar::slotClicked( int index ) {
	if( m_buttons.count() <= 0 )
		return;
	QPushButton* button = m_buttons[ index ];
	if( ! button )
		return;
  
	if( button->isOn() ) {
		setActiveIndex( index );
	}
	else {
		unSelect();
	}
}
//-----------------------------------------------
void KBearOutputToolBar::slotNewVisibleWidget( int index ) {
	if( m_popup->isVisible() )
		setActiveIndex( index );
}
//-----------------------------------------------
void KBearOutputToolBar::setActiveIndex( int index ) {
	if( m_buttons.count() <= 0 )
		return;
	QPushButton* button = m_buttons[index];
	if( ! button )
		return;
	
	unsetButtons();
	button->setOn(true);
	
	m_popup->setActiveIndex( index );


	API::getInstance()->mainWindow()->mainWindow()->makeDockVisible( m_popup );
	m_popup->show();
}
//-----------------------------------------------
void KBearOutputToolBar::unSelect() {
	API::getInstance()->mainWindow()->mainWindow()->makeDockInvisible( m_popup );
	unsetButtons();
}
//-----------------------------------------------
void KBearOutputToolBar::unsetButtons() {
	if( m_buttons.count() <= 0 )
		return;
	QIntDictIterator<QPushButton> it( m_buttons );
	while( it.current() ) {
		if( it.current()->isOn() ) {
			it.current()->setOn( false );
 		}
		++it;
	}
}
//-----------------------------------------------

