/*********************************************************************************
* C++ Interface: kbearoutputtoolbar.h
* Description:
*
* Begin : mn jan 20 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEAROUTPUTTOOLBAR_H
#define KBEAROUTPUTTOOLBAR_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qpushbutton.h>
#include <qintdict.h>
//#include <qtoolbar.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <ktoolbar.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files

class KDockWidget;
class QSignalMapper;
class KBearOutputFrame;
class QLabel;
namespace KParts {
	class DockMainWindow;
};
/**
 * 
 * @author Bjrn Sahlstrm
 **/
class KBearOutputToolBarButton : public QPushButton {
	Q_OBJECT
public:
	/** */
	KBearOutputToolBarButton( const QString& text, QWidget* parent, const char* name );
	/** */
	~KBearOutputToolBarButton();
protected:
	virtual QSize sizeHint() const;
};

/**
 * 
 * @author Bjrn Sahlstrm
 **/
class KBearOutputToolBar : public KToolBar {
	Q_OBJECT
public:
	/** */
	KBearOutputToolBar( KParts::DockMainWindow* mainWin, KDockWidget* dockTarget );
	/** */
	~KBearOutputToolBar();
	/** */
	void addWidget( QWidget* view, const QString& name, const QString& toolTip );
	/** */
	void removeWidget( QWidget* view );
	/** */
	KDockWidget* outputFrame();
private slots:
	void slotClicked( int index );
	void slotCloseButtonClicked();
	void slotWidgetDeleted();
	void slotNewVisibleWidget( int index );
private:
	void setActiveIndex( int index );
	void unSelect();
	void unsetButtons();
private:
	KBearOutputFrame* m_popup;
	int m_selected;
	QSignalMapper* m_clickedMapper;
	QIntDict<QPushButton> m_buttons;
	int m_count;
	QLabel* m_stretch;
};

#endif
