/***************************************************************************
                          kbearsplash.cpp  -  description
                             -------------------
    begin                : ons aug 14 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qstring.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qlayout.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kwin.h>
#include "kapplication.h"
#include <kstandarddirs.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearsplash.h"

#include "kbearsplash.moc"
//-----------------------------------------------
KBearSplash::KBearSplash()
	:	QWidget( 0L, "KBearSplash",WStyle_NoBorderEx|WStyle_Customize|WStyle_Tool|WType_TopLevel/*|WStyle_StaysOnTop*/ )
{
	QVBoxLayout* vbox = new QVBoxLayout( this );

	QString text = i18n( "A Graphical FTP Client for KDE" );

	QString f = locate( "appdata", "kbear-logo-top.jpg" );
	m_topPix = new QPixmap( f );
	f = locate( "appdata", "kbear-logo-bottom.jpg" );
	m_bottomPix = new QPixmap( f );

	QLabel* splashTop = new QLabel( this, "SplashTop");
	splashTop->setBackgroundMode(NoBackground);
	splashTop->setPixmap( *m_topPix );
	vbox->addWidget( splashTop );

	QLabel* splashBottom = new QLabel( text, this, "SplashBottom");
	splashBottom->setAlignment( Qt::AlignTop | Qt::AlignHCenter );
	splashBottom->setPaletteBackgroundPixmap( *m_bottomPix );
	splashBottom->setPaletteForegroundColor( QColor( 255, 242, 32 ) );
	QFont splashBottom_font(  splashBottom->font() );
	splashBottom_font.setBold( true );
	int xpos = -1;
	for( int i = 24; i > 8 && xpos < 0; i -= 2 ) { // we have to make sure the localized text is fitted into splash
		splashBottom_font.setPointSize( i );
		splashBottom->setFont( splashBottom_font );
		xpos = (400 - splashBottom->fontMetrics().width( text ) ) / 2;
	}
	vbox->addWidget( splashBottom );
	
	m_message = new QLabel( this );
	QPalette pal( m_message->palette() );
	pal.setColor( QPalette::Active, QColorGroup::Foreground, Qt::white );
	m_message->setPalette( pal );
	m_message->setBackgroundColor( Qt::black );
	vbox->addWidget( m_message );

	QRect rect = QApplication::desktop()->screenGeometry( QApplication::desktop()->screenNumber( QPoint(0,0) ) );
	move( rect.x() + ( rect.width() - sizeHint().width() ) / 2, rect.y() + ( rect.height() - sizeHint().height() ) / 2);
	setFixedSize( sizeHint() );
	
	show();
}
//-----------------------------------------------
KBearSplash::~KBearSplash() {
	delete m_topPix;
	delete m_bottomPix;
}
//-----------------------------------------------
void KBearSplash::slotShowMessage( const QString& message ) {
//	kdDebug()<<"KBearSplash::slotShowMessage()="<<message<<endl;
	m_message->setText( message );
	QApplication::flushX();
	kapp->processEvents();
}
//-----------------------------------------------
