/***************************************************************************
                          connectionmanager.h  -  description
                             -------------------
    begin                : ons dec 18 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONNECTIONMANAGER_H
#define CONNECTIONMANAGER_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
#include <qevent.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/slave.h>
#include <kio/global.h>
#include <kio/jobclasses.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include <siteinfo.h>




namespace KBear {
	class Transfer;
	class ConnectionInterface;

	/**
	* The ConnectionManager can be seen as an extension or drop in for the KIO::Scheduler.
	* It manages all connections and jobs for KBear. Each connection is encapsulated in a @ref Connection.
	* When creating a @ref Connection it's associated with an unique ID. Use this ID for all operations.
	* @author Bjrn Sahlstrm
	*/
	class ConnectionManager : public QObject {
		Q_OBJECT
		friend class KBearCore;
		friend class TransferManager;
	public:
		/** */
		virtual ~ConnectionManager();
		/** */
		static ConnectionManager* getInstance();
		/**
		* Creates a new @ref Connection using the given @ref SiteInfo.
		* Before calling this you MUSt have called either createNewSite or createNewConnection
		* If not nothing wil be done.
		* @param ID should contain the ID for the connection to open the @ref Connection.
		* @return  the @ref KIO::Slave associated with the @ref Connection.
		*/
		bool openConnection( int ID );
		/**
		* Closes the @ref Connection associated with ID.
		* @param ID must contain the label associated with the connection to close.
		*/
		void closeConnection( int ID );
		/**
		* This is an overloaded member function, provided for convenience. It behaves essentially like the above function.
		*/
		void closeConnection( const SiteInfo& info );
		/**
		* @param must contain the ID assosiated with the wanted @ref SiteInfo.
		* @return the @ref SiteInfo associated with the given ID.
		*/
		SiteInfo getSiteInfo( int ID );
		/** */
		void attachJob( int ID, KIO::SimpleJob* );
		/**
		* Do NOT use this, for internal use only.
		* This will create a new SiteConnection
		*/
		bool createNewSite( SiteInfo& );
		/**
		* Do NOT use this, for internal use only.
		* This will create a new Connection
		@see #openConnection
		*/
		bool createNewConnection( SiteInfo& );
		/** */
		bool suspend( int ID );
		/** */
		bool resume( int ID );
		/** */
		void cleanUp();
	signals:
		/** */
		void infoMessage( int, const QString& );
		/**
		* This signal is emitted when a non-site connection has been closed
		*/
		void connectionClosed( int );
		/**
		* This signal is emitted when a site has been closed
		*/
		void siteClosed( int );
		/**
		* Emitted when the connection with ID has connected succesfully
		*/
		void connected( int ID );
		/**
		* Emitted when the connection with ID has lost connection
		*/
		void notConnected( int );
		/**
		* Emitted on errors
		*/
		void error( int ID, int error, const QString& errMsg );
	private slots:
			void slotConnectionClosed( int );
			void slotConfigNeeded( const QString&, const QString& );
	private: // Private methods
		/* There must only be one instance of ConnectionManager. That's the reason the
		* constructor is private. Use the static method @ref getInstance to create and use the object.
		*/
		ConnectionManager();
		int getNewID();
		ConnectionInterface* getConnectionByID( int ID );
		ConnectionInterface* getConnectionBySiteInfo( const SiteInfo& info );
		ConnectionInterface* getConnectionByLabel( const QString& label );
		bool checkNameIntegrity( const QString& label );
		void removeConnection( ConnectionInterface* );
		QString getConnectionLabel( const QString& label );
	private: // Private attributes
		static ConnectionManager* s_instance;
		class ConnectionManagerPrivate;
		ConnectionManagerPrivate* d;
	};
};
#endif
