/***************************************************************************
                          group.h  -  description
                             -------------------
    begin                : tor mar 14 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GROUP_H
#define GROUP_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qstring.h>
#include <qdatastream.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files

/**
  *@author Bjrn Sahlstrm
  */

namespace KBear {
	class Group {
	public:
		/** */
		Group();
		/** */
		~Group();
		/** */
		QString label() const;
		/** */
		QString parent() const;
		/** */
		void setLabel( const QString& label );
		/** */
		void setParent( const QString& parent );
		/** */
		void insert( QDataStream& out ) const;
		/** */
		void extract( QDataStream& in );
	private:
		class GroupPrivate;
		GroupPrivate* d;
		QString m_label;
		QString m_parent;
	};
};
///////////////////////////////////////////////////////
inline QDataStream& operator << ( QDataStream& s,  const KBear::Group& group ) {
	group.insert( s );
	return s;
}
///////////////////////////////////////////////////////
inline QDataStream& operator >> ( QDataStream& s, KBear::Group& group ) {
	group.extract( s );
	return s;
}

#endif
