/*********************************************************************************
* C++ Interface: kbearconfigwidgetiface..h
* Description:
*                              
* Begin : tis jan 15 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARKBEARCONFIGWIDGETIFACE_H
#define KBEARKBEARCONFIGWIDGETIFACE_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qstring.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files

namespace KBear {
/**
	* Use this class as base class for all config widgets. Sets up an interface for communication with the widget.
	* @author Bjrn Sahlstrm
**/
	class KBearConfigWidgetIface : public QWidget {
		Q_OBJECT
	public:
		/** */
		KBearConfigWidgetIface( QWidget* parent, const char* name = 0 );
		/** */
		virtual ~KBearConfigWidgetIface();
		/**
		* Reimplement this method if your config widget has a help section.
		* @return the name of the help section to use or QString::null.
		* Default implementation returns QString::null.
		*/
		virtual QString helpSection() const { return QString::null; }
		/**
		* Reimplement this method to indicate if your config widget has a help section.
		* @return true if a help section is available and false if no. 
		*/
		virtual bool helpEnabled() const = 0;
		/** 
		* Reimplement this method to read your settings.
		*/
		virtual void readSettings( bool defaultSettings = false ) = 0;
		/** 
		* Reimplement this method to save your settings.
		*/
		virtual void saveSettings() = 0;
		/**
		* Reimplement this method to apply your settings.
		* Default implementation does nothing.
		*/
		virtual void applySettings() {} 
		/** 
		* Reimplement this method if you need to do something special to add a widget to your layout.
		* Default implementation just calls layout()->add( widget ).
		*/
		virtual void swallow( QWidget* widget );
};

};
#endif
