/*********************************************************************************
* C++ Implementation: kbearcore.cpp
* Description:
*                              
* Begin : tis jan 14 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kdialogbase.h>
#include <kwizard.h>
#include <kpopupmenu.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearcore.h"
#include "kbearapi.h"
#include "transfermanager.h"
#include "kbearmainwiniface.h"
#include "connectionmanager.h"

#include "kbearcore.moc"

using namespace KBear;
class KBearCore::KBearCorePrivate {
	public:
		KBearCorePrivate() : m_abortShutDown( false ) {}
		bool m_abortShutDown;
};
//-----------------------------------------------
KBearCore::KBearCore( QObject* parent )
	: QObject( parent, "KBearCore" )
{
	d = new KBearCorePrivate;
}
//-----------------------------------------------
KBearCore::~KBearCore() {
	delete d;
}
//-----------------------------------------------
void KBearCore::openSite( const SiteInfo& info ) {
	SiteInfo site = info;
	QString origLabel = info.label();
	if( ! ConnectionManager::getInstance()->createNewSite( site ) )
		return;
	// notify that a new site is opened before it's actually opened
	SiteInfo origInfo = site;
	origInfo.setLabel( origLabel );
	emit newSite( site );
	emit newSite( origInfo, site );
	KBearMainWindowInterface::getInstance()->openConnection( site );
}
//-----------------------------------------------
void KBearCore::abortShutDown() {
	d->m_abortShutDown = true;
}
//-----------------------------------------------
bool KBearCore::shutDownAborted() const {
	return d->m_abortShutDown;
}
//-----------------------------------------------
void KBearCore::requestShutDown() {
	d->m_abortShutDown = false;
	emit shutDownRequested();
	// this will be true if any object have reqested to abort shutdown see KBearCore::abortShutDown()
	if( ! d->m_abortShutDown ) {
		slotQuit();
	}
	d->m_abortShutDown = false;
}
//-----------------------------------------------
