/*********************************************************************************
* C++ Interface: kbearcore.h
* Description:
*                              
* Begin : tis jan 14 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/


#ifndef KBEARCORE_H
#define KBEARCORE_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/global.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "siteinfo.h"

class KDialogBase;
class KPopupMenu;
class KWizard;

namespace KBear {
	/**
	* 
	* @author Bjrn Sahlstrm
	**/
	class KBearCore : public QObject {
			Q_OBJECT
		public:
			/** */
			KBearCore( QObject* );
			/** */
			virtual ~KBearCore();
			/** */
			void emitNewToolbarConfig() {
				emit newToolbarConfig();
			}
			/** */
			void emitNewSite( const SiteInfo& info ) {
				emit newSite( info );
			}
			/** */
			void emitNewSite( const SiteInfo& origInfo, const SiteInfo& info ) {
				emit newSite( origInfo, info );
			}
			/** */
			void emitInitialized() {
				emit initialized();
			}
			/** */
			void emitConfigWidget( KDialogBase* dlg ) {
				emit configWidget( dlg );
			}
			/** */
			void emitConfigWidget( KWizard* wiz ) {
				emit configWidget( wiz );
			}
			/**
			* Call this method when you need the @ref KIO::MetaData to be filled
			*/
			void emitMetaDataNeeded( KIO::MetaData& metaData ) {
				emit metaDataNeeded( metaData );
			}
			/**
			* Call this method when you need the @ref KIO::MetaData to be filled
			*/
			void emitSystemTrayMenuNeeded( KPopupMenu* menu ) {
				emit systemTrayMenuNeeded( menu );
			}
			/**
			* Call this method if you want to abort application shutdown.
			* For example if user canceled in a query exit dialog.
			*/
			void abortShutDown();
			/**
			* @return true if shutdown is aborted
			*/
			bool shutDownAborted() const;
		public slots:
			/** 
			* Call this when you want to request an application shut down
			*/
			void requestShutDown();
			/*
			* Connect to this slot when you want to open a new site.
			* The signal @ref #newSite will be emitted containing the site that is opened.
			* Note that the SiteInfo emitted in @ref #newSite may differ from the one given here, especially the label.
			* @param info should contain the necessary information needed to connect to the site.
			*/
			void openSite( const SiteInfo& info );
		signals:
			/**
			* This signal is emitted just before a new site is opened.
			* Connect to this signal if you need to be notified about this.
			*/
			void newSite( const SiteInfo& info );
			/**
			* This signal is emitted just before a new site is opened.
			* Connect to this signal if you need to be notified about this.
			*/
			void newSite( const SiteInfo& origInfo, const SiteInfo& info );
			/**
			* This signalis emitted just before the aplication is shutting down.
			* Connect to this signal if you need to be notified about this.
			* At this point there isn't possible to stop the application from shuttingdown.
			* If you need to do this you should connect to @ref #shutDownRequested instead.
			* This signal is just meant for final clean up.
			*/
			void shuttingDown();
			/** 
			* This signal is emitted when the mainwindow has requested a shutdown of the application.
			* Connect to this sigal if you need to do any clean up before shutdown.
			*/
			void shutDownRequested();
			/** 
			* Emitted when MainWindow is initialized and shown.
			*/
			void initialized();
			/** 
			* Connect to this signal if you have a config widget that should be shown in 
			* the config dialog. Do like this:
			* <pre>
			*	QObject::connect( Core::getInstance(), SIGNAL( configWidget( KDialogBase* ) ), this, SLOT( slotConfigWidget(KDialogBase*))); 
				void MyClass::slotConfigWidget(KDialogBase *dlg) {
			*	QVBox *vbox = dlg->addVBoxPage( i18n("PLUGIN NAME"));
			* 	PLUGINWIDGET *w = new PLUGINWIDGET(vbox, "name");
			*	}
			* </pre>
			* and whatever else you need.
			*/
			void configWidget( KDialogBase* );
			/** 
			* Connect to this signal if you have a config widget that should be shown in 
			* the wizard dialog. Do like this:
			* <pre>
			*	QObject::connect( Core::getInstance(), SIGNAL( configWidget( KWizard* ) ), this, SLOT( slotConfigWidget(KWizard*))); 
				void MyClass::slotConfigWidget(KDialogBase* wiz) {
			* 	PLUGINWIDGET* w = new PLUGINWIDGET(vbox, "name");
			*	wiz->addPage( w, i18n("PLUGIN NAME") );
			*	}
			* </pre>
			* and whatever else you need.
			*/
			void configWidget( KWizard* );
			/** 
			* Emitted when the toolbar config has been changed.
			* Connect to this signal if your plugin depends on this.
			*/
			void newToolbarConfig();
			/** 
			* This signal is emitted when metadata is needed for a connection
			* @param metaData is the contains the @ref KIO::MetaData to fill
			*/
			void metaDataNeeded( KIO::MetaData& metaData );
			/** 
			* This signal is emitted when the system tray menu is about to show
			* @param menu is the @ref KPopupMenu to fill
			*/
			void systemTrayMenuNeeded( KPopupMenu* menu );
		protected slots:
			virtual void slotQuit() = 0;
		protected:
			class KBearCorePrivate;
			KBearCorePrivate* d;
	};
};
#endif
