/*********************************************************************************
* C++ Interface: kbeardomhelper.h
* Description:
*                              
* Begin : lr feb 01 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/


#ifndef _KBEARDOMHELPER_H_
#define _KBEARDOMHELPER_H_

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qdom.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files


/**
 * 
 * Bjrn Sahlstrm
 **/
namespace KBear {
	class KBearDomHelper {
	public:
		/** 
		*If 'value' is true: an empty tag with tagname 'tag' is created in document 'doc' with 'parentNode' as parent if it's not exist.
		*If 'value' is false: removes 'tag' if it exists.
		*@param doc the @ref QDomDocument to work in.
		*@param parentNode the @ref QDomNode that is the parent to the tag to create/remove.
		*@param tag name of the tag to create/remove.
		*@param value tells wether to create or to remove the tag.
		*/
		static void createBoolValue( QDomDocument& doc, QDomElement& parentNode, const QString& tag, bool value );
		/** 
		*Creates a text node with tagname 'tag' in document 'doc' with 'parentNode' as parent and sets the text to 'value'.
		*@param doc the @ref QDomDocument to work in.
		*@param parentNode the @ref QDomNode that is the parent to the tag to create.
		*@param tag name of the tag to create.
		*@param value the text ;).
		*/
		static void addTextNode( QDomDocument& doc, QDomElement& parentNode, const QString& tag, const QString& value );
		/** 
		*@return the text value of  tag 'tagName'.
		*@param parent the parent node to look in
		*@param tagName the tag to look in
		*/
		static QString getNodeValue( const QDomElement& parent, const QString& tagName );
		/** 
		* Sets the text value for specified tag
		*@param doc the @ref QDomDocument to work in.
		*@param parentNode the @ref QDomNode that is the parent to the tag to set.
		*@param the text value to set.
		*@param parent the parent node to look in
		*@param tagName the tag to set
		*/
		static void setNodeValue( QDomDocument& doc, QDomElement& parentNode, const QString& tagName, const QString& value );
		/** 
		*@return the attribute value for the specified attribute
		*@param parentNode the @ref QDomNode that is the parent to the tag to get.
		*@param tagName the tag to look in
		*@param attr the attribute to check
		*/
		static QString getAttribute( const QDomElement& parentNode, const QString& tagName, const QString& attr );
		/** 
		*Sets the attribute value for the specified attribute
		*@param parentNode the @ref QDomNode that is the parent to the tag to get.
		*@param tagName the tag to look in
		*@param attr the attribute to check
		*/
		static void setAttribute( const QDomElement& parentNode, const QString& tagName, const QString& attr, const QString& value );
		/** 
		*@return the first found @ref QDomElement with the specified tag name
		*@param parentNode the @ref QDomNode that is the parent to the element to get.
		*@param tagName the tag to look for
		*/
		static QDomElement getElement( const QDomElement& parentNode, const QString& tagName );
		/** 
		*Creates an empty tag with tagname 'tag' in document 'doc' with 'parentNode' as parent.
		*@param doc the @ref QDomDocument to work in.
		*@param parentNode the @ref QDomNode that is the parent to the tag to create.
		*@param tag name of the tag to create.
		*/
		static QDomElement addEmptyElement( QDomDocument& doc, QDomElement& parentNode, const QString& tag );
		/** 
		*Removes an empty tag with tagname 'tag' with 'parentNode' as parent.
		*@param parentNode the @ref QDomNode that is the parent to the tag to create.
		*@param tag name of the tag to create.
		*/
		static void removeEmptyElement( QDomElement& parentNode, const QString& tag );
		/**
		*@return a @ref QDomNode found by a specified attribute.
		*@param parent the @ref QDomElement the is the parent of the Node to find.
		*@param tagName the name of the attribute's tag.
		*@param attribute the attribute's name.
		*@param label the attribute's label.
		*/
		static QDomNode findNodeByAttribute( QDomElement& parent, const QString& tagName, const QString& attribute, const QString& label );
	};
};

#endif
