/*********************************************************************************
* C++ Interface: kbearfilesyspartiface.h
* Description:
*                              
* Begin : tis jan 18 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARFILESYSPART_H
#define KBEARFILESYSPART_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qptrstack.h>
#include <qvaluelist.h>
#include <qptrlist.h>
#include <qdatetime.h>
#include <qpoint.h>
#include <qdir.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kfile.h>
#include <kaction.h>
#include <kparts/event.h>
#include <kparts/part.h>
#include <kaboutdata.h>
#include <kio/jobclasses.h>
#include <kfileitem.h>
#include <kurl.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearpartiface.h"
#include "kbearfilesyswidget.h"
#include "siteinfo.h"

class QPopupMenu;
class QTimer;
class KFileItem;
class KFileView;
class KConfig;
class QMimeSource;

namespace KBear {
	class KBearDirView;
	class KBearDirListerIface;
	/**
		*
		* @author Bjrn Sahlstrm
		**/
	class KBearFileSysPartInterface : public KParts::Part,  public KBearPartInterface {
		Q_OBJECT
	public:
		enum State {
			GUIDisabled = 1,
			GUIEnabled = 2,
			FilePreview = 4,
			FileNormal = 8,
			ListingState = 16
		};
		/** */
		KBearFileSysPartInterface( QWidget* parentWidget, const char* widgetName, QObject* parent, const char* name, const QStringList& = QStringList() );
			/** */
		virtual ~KBearFileSysPartInterface();
		/** */
		void init( const SiteInfo& info );
		/** */
		virtual KURL currentURL() const { return m_url; };
		/** */
		KURL lastURL() const;
		/** */
		const KURL::List selectedURLs() const;
		/** */
		const KFileItemList* selectedItems() const;
		/**
		* @return the popup menu of the part.
		*/
		virtual QPopupMenu* popupMenu();
		/** */
		virtual void openConnection( const SiteInfo& c );
		/** */
		virtual void setPath( const QString& path );
		/** */
		virtual QString fromUnicode( const QString& str ) = 0;
		/** */
		virtual QString toUnicode( const QString& str ) = 0;
		/** */
		KParts::Part* activePart();
		/** */
		virtual void showToolBarUpper( bool );
		/** */
		virtual void showToolBarLower( bool );
		/** */
		virtual void showStatusBarUpper( bool );
		/** */
		virtual void showStatusBarLower( bool );
		/** */
		void readProperties( KConfig* config,  const QString& group );
		/** */
		void saveProperties( KConfig* config,  const QString& group );
		/**
		* A view factory for creating predefined fileviews.
		*/
		virtual KBearDirView* createTreeView( QWidget* parent, const SiteInfo& info ) = 0;
		/**
		* A view factory for creating predefined fileviews.
		*/
		virtual KFileView* createView( QWidget* parent, KFile::FileView view ) = 0;
		/** No descriptions */
		virtual void openWith( const KURL::List& ) = 0;
		/** */
		void updateSortActions();
		/** */
		void updateViewActions();
	public slots:
		/** */
		virtual void reload();
		/** */
		virtual void home();
		/** */
		virtual void cdUp();
		/** */
		virtual void back();
		/** */
		virtual void forward();
		/** */
		virtual void stop();
		/** */
		void slotCopy();
		/** */
		void slotCut();
		/** */
		void slotPaste();
		/** */
		void slotFind();
		/** */
		void slotFindNext();
		/** */
		void slotSetWindowCaption( const QString& str );
	signals:
		/**
		* Emitted everytime the part gets acivated
		*/
		void activated();
		/**
		* Emitted everytime the selection changes
		*/
		void selectionChanged();
		/**
		* Emitted when the part wants to be closed, normally after an error
		*/
		void closeMe();
	protected:
		/** */
		virtual void guiActivateEvent( KParts::GUIActivateEvent* event );
		/** */
		State state() const;
		/** */
		KBearDirListerIface* dirLister() { return m_myWidget->dirLister(); }
		/** */
		void setState( unsigned int );
		/** */
		virtual void openURL( const KURL& u );
		/** */
		void setupConnections();
		/** */
		int setupOpenWithMenu();
		/** */
		void updateHistoryActions();
		/** */
		void addToBackHistory( const KURL& url );
		/** */
		unsigned int getPreviewMode();
		/** No descriptions */
		virtual void executeService( const QString& exec, const KURL::List& urlList, const QString& name, const QString& icon ) = 0;
		/** */
		KIO::Job* copyFile( int sID, int dID, const KURL& source, const KURL& dest );
	protected slots:
		/** No descriptions */
		void slotOpenWith();
		/** No descriptions */
		void slotOpenWithService(int);
		/** */
		virtual void slotProperties() = 0;
		/** */
		void slotDelete();
		/** */
		virtual void slotSetupPopupMenu();
		/** */
		virtual void slotStartLoading();
		/** */
		virtual void slotFinishedLoading();
		/** */
		virtual void slotViewActionAdded( KAction * );
		/** */
		virtual void slotViewActionRemoved( KAction * );
		/** */
		void slotSelectionChanged();
		/** */
		virtual void slotActivatedMenu( const KFileItem *, const QPoint& pos );
		/** */
		virtual void slotResult( KIO::Job* job );
		/** */
		virtual void slotError( int, const QString& );
	private slots:
		void slotPreviewJobFinised( KIO::Job* );
		void slotFileNameChanged();
		void slotProgress( KIO::Job*, unsigned long );
		void slotSpeed( KIO::Job*, unsigned long );
		void slotOpenFile( const KURL& url, bool inInternalEditor=false );
		void slotNewDir(const KURL& );
		void slotPathActivated( const QString& path );
		void slotConnected();
		void slotOpenConnection();
		void slotSetupViewMenu();
		void slotClipboardDataChanged();
		void slotClearSelection();
		void slotSelectAll();
		void slotInvertSelection();
		void slotMakeDir();
		void slotUpdateTime();
		void slotClearStatusBar();
		void slotPathChanged();
		void slotOpenEditor();
		void slotDropped( QMimeSource*, const QPoint& );
	private:
		void clearHistory();
		void doCutCopy( bool cut );
		void connectView(KFileView* );
		void setup();
		void setupActions();
		void unloadPreviewPart();
		void searchView( const QString& pattern, long options,KFileItem* startItem );
	protected:
		KURL m_url;
		SiteInfo m_siteInfo;
		KActionCollection* m_viewActionCollection;
		QPopupMenu* m_actionMenu;
		KAction* m_openEditorAction;
		KBearFileSysWidget* m_myWidget;
		static const unsigned int s_viewActionCount;
	private:
		class KBearFileSysPartInterfacePrivate;
		KBearFileSysPartInterfacePrivate* d;
	};
};

#endif
