/***************************************************************************
                          KBearMainWindowInterface.cpp  -  description
                             -------------------
    begin                : mn jan 13 2003
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
/////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearmainwiniface.h"
#include "siteinfo.h"

using namespace KBear;

//-----------------------------------------------
KBearMainWindowInterface* KBearMainWindowInterface::s_instance = 0L;
//-----------------------------------------------
KBearMainWindowInterface::KBearMainWindowInterface()
	:	DCOPObject( "KBearMainWindow" )
{
	s_instance = this;
}
//-----------------------------------------------
KBearMainWindowInterface::~KBearMainWindowInterface() {
}
//-----------------------------------------------
KStatusBar* KBearMainWindowInterface::statusBar() {
	return mainWindow()->statusBar();
}
//-----------------------------------------------
KBearMainWindowInterface* KBearMainWindowInterface::getInstance() {
	Q_ASSERT( s_instance );
	return s_instance;
}
//-----------------------------------------------
void KBearMainWindowInterface::openURL( QString u ) {
	KURL url( u );
	if( url.protocol() == QString::fromLatin1( "ftp" ) )
		url.setProtocol( QString::fromLatin1( "kbearftp" ) );
	SiteInfo site( url );
	// We must go through the Core object so signals are emitted correctly
	core()->openSite( site );
}
//-----------------------------------------------
void KBearMainWindowInterface::openConnection( const SiteInfo& info ) {
	QString whatsThis = i18n("This Window displays the remote file system.\n"
									"You can use this to transfer files and folders to or "
									"from any other open file system by drag and drop.");

	raiseMainWindow(); // make sure the app is visible

	(void)createClient( info, whatsThis );
	setLocalPath( info.localPath() );
}
//-----------------------------------------------
void KBearMainWindowInterface::openConnection( QString c ) {
	SiteInfo site( c );
	// We must go through the Core object so signals are emitted correctly
	core()->openSite( site );
}
//-----------------------------------------------
