/***************************************************************************
                          kbearmainwiniface.h  -  description
                             -------------------
    begin                : mn jan 13 2003
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARMAINWINIFACE_H
#define KBEARMAINWINIFACE_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qstring.h>
#include <qptrlist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <dcopref.h>
#include <dcopobject.h>
#include <kparts/dockmainwindow.h>
#include <kstatusbar.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearcore.h"
#include "kbearapi.h"
#include "siteinfo.h"

class KConfig;


namespace KBear {
/**
* @author Bjrn Sahlstrm
*/
	class KBearChildViewIface;
	class KBearConfigWidgetIface;

	class KBearMainWindowInterface : virtual public DCOPObject {
		K_DCOP
	public:
		/** */
		KBearMainWindowInterface();
		/** */
		virtual ~KBearMainWindowInterface();
		/** */
		virtual void embedOutputPluginView( QWidget *view, const QString &title, const QString &toolTip) = 0;
		/** */
		virtual void removeOutputPluginView( QWidget *view ) = 0;
		/** */
		virtual void raiseView(QWidget *view) = 0;
		/** */
		virtual void openConnection( const SiteInfo& );
		/** */
		virtual KParts::DockMainWindow* mainWindow() = 0;
		/** */
		KStatusBar* statusBar();
		/** */
		virtual void realClose() = 0;
		/** */
		virtual void setLocalPath( const QString& ) = 0;
		/** */
		virtual void init() = 0;
		/** */
		virtual KBearCore* core() = 0;
		/** */
		virtual KBearAPI* api() = 0;
		/** */
		virtual KBearConfigWidgetIface* miscSettingsWidget() = 0;
		/** */
		static KBearMainWindowInterface* getInstance();
		/** */
		virtual void readViewSettings() = 0;
		/** */
		virtual void applyUISettings() = 0;
		/** */
		virtual void showViewLocal() = 0;
		/** */
		virtual void closeCurrentView() = 0;
		/** */
		virtual const KBearChildViewIface* getCurrentView() = 0;
		/** */
		virtual const KBearChildViewIface* getLocalView() = 0;
		/** */
		virtual void closeAll() = 0;
		/** */
		virtual QPtrList<KBearChildViewIface> childViews() = 0;
		/**
		* This method is called when it is time for the app to save its
		* properties for session management purposes.
		*/
		virtual void saveProperties( KConfig* ) = 0;
		/**
		* This method is called when this app is restored.  The KConfig
		* object points to the session management config file that was saved
		* with @ref saveProperties
		*/
		virtual void readProperties( KConfig* ) = 0;
	k_dcop:
		/** */
		virtual ASYNC raiseMainWindow() = 0;
		/** */
		virtual ASYNC openURL( QString url );
		/** */
		virtual ASYNC openConnection( QString connection );
		/** @return reference to the current childView */
		virtual DCOPRef currentChildView() = 0;
	private:
		virtual KBearChildViewIface* createClient( const SiteInfo& info, const QString& whatsThis ) = 0;
	private:
		static KBearMainWindowInterface* s_instance;
	};

};
#endif

