/*********************************************************************************
* C++ Interface: kbearpluginmanageriface.h
* Description:
*
* Begin : lr maj 3 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef PLUGINMANAGERINTERFACE_H
#define PLUGINMANAGERINTERFACE_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
#include <qstring.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files


namespace KBear {
	class KBearPlugin;

	/**
		*
		* @author Bjrn Sahlstrm
		**/
	class KBearPluginManagerInterface : public QObject {
		Q_OBJECT
	public:
		/** */
		KBearPluginManagerInterface( QObject* );
		/** */
		virtual ~KBearPluginManagerInterface();
		/** */
		virtual void loadPlugins( bool initializePlugins = false ) = 0;
		/** */
		virtual void addPlugin( KBear::KBearPlugin* client ) = 0;
		/** */
		virtual void removePlugin( KBear::KBearPlugin* client ) = 0;
	signals:
		/**
		Emitted after a new @ref KBearPlugin has been loaded
		*/
		void loadingPlugin( const QString& );
		/**
		Emitted after a new @ref KBearPlugin has been unloaded
		*/
		void pluginLoaded( KBear::KBearPlugin* );
		/**
		Emitted after a new @ref KBearPlugin has been loaded
		*/
		void pluginUnloaded( KBear::KBearPlugin* );
	};
};
#endif
