/***************************************************************************
                          siteimportfilterluginiface.h  -  description
                             -------------------
    begin                : ons mar 20 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SITEIMPORTFILTERPLUGINIFACE_H
#define SITEIMPORTFILTERPLUGINIFACE_H
//////////////////////////////////////////////////////
// Qt specific includes
//////////////////////////////////////////////////////
// KDE specific includes
#include <kparts/plugin.h>
//////////////////////////////////////////////////////
// Application specific includes

namespace KBear {
/**
	* This is an abstract base class for all site import filter plugins.
	* It sets up an interface that make it possible for the @ref KBearSiteManager
	* to communicate with the plugin.
	* @short This is an abstract base class for all site import filter plugins.
	*@author Bjrn Sahlstrm
  */
	class SiteImportFilterPluginIface : public KParts::Plugin {
		Q_OBJECT
	public:
		/** */
		SiteImportFilterPluginIface(QObject *parent, const char *name=0);
		/** */
		virtual ~SiteImportFilterPluginIface();
		/**
		* This function should return a @ref QDomDocument containing the imported bookmarks.
		* The document should have the format:
		* <pre>
		*	group label="APPNAME-imports"
		*		group label="group1"
		*			site label="site1"
		*			............	
		*			/site
		*			.................
		*		/group
		*		...................
		*	/group
		*</pre>
		* @return the @ref QDomDocument s @ref QString representation containing the imported bookmarks.
		*/
		virtual QString getDomDocument() = 0;	
		/**
		* Function should start the import
		* @param fileName is the full path to the file to import
		*/
		virtual void import( const QString& fileName ) = 0;
		/**
		* This function is used by the caller to find out wether or not
		* the import was successfull. If anything went wrong during
		* import this function should return true.
		* This stop update of database.
		* @return false om success or true on error.
		*/
		virtual bool hasError() const = 0;
	signals:
		/**
		* Signal to emit progress during import ( 0 -> 100).
		* Note: Don't emit 100 until import is totally finished,
		* since this triggers the plugin to be unloaded.
		*/
		void progress( int );	
	};
};

#endif
