/*********************************************************************************
* C++ Interface: sitechildsingleconnection.h
* Description:
*
* Begin : mn jun 2 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARSITECHILDSINGLECONNECTION_H
#define KBEARSITECHILDSINGLECONNECTION_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "childsingleconnection.h"
#include "toplevelconnectioninterface.h"

namespace KBear {

	/**
	@author Bjrn Sahlstrm
	*/
	class SiteChildSingleConnection : virtual public ChildSingleConnection, virtual public TopLevelConnectionInterface {
			Q_OBJECT
		public:
			/** */
			SiteChildSingleConnection( TopLevelConnectionInterface* parent, const SiteInfo& info );
			/** */
			virtual ~SiteChildSingleConnection();
			/**
			* Call this to open the connection
			*/
			virtual bool openConnection();
			/**
			* Adds a @ref ConnectionInterface as a child to this Connection
			* @param connection the @ref ConnectionInterface to add
			*/
			virtual void addConnection( ConnectionInterface* connection );
			/**
			* Removes a @ref ConnectionInterface that is a child to this Connection
			* @param connection the @ref ConnectionInterface to remove
			*/
			virtual void removeConnection( ConnectionInterface* connection );
		protected slots:
			virtual void slotInfoMessage( int, const QString& message );
			virtual void slotConnectionClosed( int ID );

	};

};

#endif
