/*********************************************************************************
* C++ Implementation: toplevelconnection.cpp
* Description:
*
* Begin : lr maj 24 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qapplication.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/slave.h>
#include <kio/scheduler.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "toplevelconnection.h"


#include "toplevelconnection.moc"

using namespace KBear;
//-----------------------------------------------
TopLevelConnection::TopLevelConnection( const SiteInfo& info )
	:	ConnectionInterface( info ),
		m_closeWhenEmpty( false )
{
}
//-----------------------------------------------
TopLevelConnection::TopLevelConnection()
	:	m_closeWhenEmpty( false )
{
}
//-----------------------------------------------
TopLevelConnection::~TopLevelConnection() {
	kdDebug()<<k_funcinfo<<" ID="<<m_siteInfo.ID()<<endl;
}
//-----------------------------------------------
void TopLevelConnection::closeConnection( bool force ) {
	if( force || m_connectionList.isEmpty() ) {
		if( m_slave ) {
			if( m_slave->isAlive() ) {
				KIO::Scheduler::disconnectSlave( m_slave );
				slaveDied();
			}
		}
		if( ! force ) {
			emit closed( m_siteInfo.ID() );
		}
	}
	else
		m_closeWhenEmpty = true;
}
//-----------------------------------------------
void TopLevelConnection::addConnection( ConnectionInterface* connection ) {
	if( ! connection )
		return;

	m_connectionList.insert( connection->getInfo().ID(), connection );
	connect( connection, SIGNAL( infoMessage( int, const QString& ) ),
						this, SLOT( slotInfoMessage( int, const QString& ) ) );
	connect( connection, SIGNAL( closed( int ) ), this, SLOT( slotConnectionClosed( int ) ) );
}
//-----------------------------------------------
void TopLevelConnection::removeConnection( ConnectionInterface* connection ) {
	if( ! connection )
		return;

	m_connectionList.remove( connection->getInfo().ID() );
	if( m_closeWhenEmpty && m_connectionList.isEmpty() ) {
		closeConnection();
	}
}
//-----------------------------------------------
void TopLevelConnection::slotConnectionClosed( int ID ) {
	removeConnection( m_connectionList.find( ID ) );
}
//-----------------------------------------------
void TopLevelConnection::slotInfoMessage( int, const QString& message ) {
	if( m_siteInfo.enableLog() )  {// Only post if log is enabled
		emit infoMessage( m_siteInfo.ID(), message );
	}
}
//-----------------------------------------------
