/*********************************************************************************
* C++ Interface: toplevelconnection.h
* Description:
*
* Begin : ons maj 7 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARTOPLEVELCONNECTION_H
#define KBEARTOPLEVELCONNECTION_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qevent.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/global.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "toplevelconnectioninterface.h"

namespace KIO {
	class Slave;
}

namespace KBear {

	/**
	@author Bjrn Sahlstrm
	*/
	class TopLevelConnection : virtual public TopLevelConnectionInterface {
		Q_OBJECT
	public:
			/** */
			TopLevelConnection( const SiteInfo& info );
			/** */
			TopLevelConnection();
			/** */
			virtual ~TopLevelConnection();
			/**
			* Call this to close the connection
			*/
			virtual void closeConnection( bool force = false );
			/**
			* Adds a @ref ConnectionInterface as a child to this Connection
			* @param connection the @ref ConnectionInterface to add
			*/
			virtual void addConnection( ConnectionInterface* connection );
			/**
			* Removes a @ref ConnectionInterface that is a child to this Connection
			* @param connection the @ref ConnectionInterface to remove
			*/
			virtual void removeConnection( ConnectionInterface* connection );
		protected slots:
			virtual void slotInfoMessage( int, const QString& message );
			virtual void slotConnectionClosed( int ID );
		protected:
			bool m_closeWhenEmpty;
	};

};

#endif
