/*********************************************************************************
* C++ Interface: toplevelconnectioninterface.h
* Description:
*
* Begin : ons maj 7 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARTOPLEVELCONNECTIONINTERFACE_H
#define KBEARTOPLEVELCONNECTIONINTERFACE_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qintdict.h>
#include <qguardedptr.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "connectioninterface.h"

namespace KBear {

	/**
	@author Bjrn Sahlstrm
	*/
	class TopLevelConnectionInterface : virtual public ConnectionInterface {
			Q_OBJECT
		public:
			/** */
			TopLevelConnectionInterface();
			/** */
			virtual ~TopLevelConnectionInterface();
			/**
			* Adds a @ref ConnectionInterface as a child to this Connection
			* @param connection the @ref ConnectionInterface to add
			*/
			virtual void addConnection( ConnectionInterface* connection ) = 0;
			/**
			* Removes a @ref ConnectionInterface that is a child to this Connection
			* @param connection the @ref ConnectionInterface to remove
			*/
			virtual void removeConnection( ConnectionInterface* connection ) = 0;
		protected slots:
			virtual void slotInfoMessage( int, const QString& message ) = 0;
			virtual void slotConnectionClosed( int ID ) = 0;
		protected:
			/** */
			QIntDict<ConnectionInterface> m_connectionList;
	};

};

#endif
