/*********************************************************************************
* C++ Implementation: transfergroup.cpp
* Description:
*
* Begin : sn maj 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "transfergroup.h"
#include "transfer.h"

#include "transfergroup.moc"

using namespace KBear;

//-----------------------------------------------
TransferGroup::TransferGroup( QObject* parent, int ID )
	:	QObject( parent ),
		m_ID( ID )
{
}
//-----------------------------------------------
TransferGroup::~TransferGroup() {
	kdDebug()<<k_funcinfo<<endl;
}
//-----------------------------------------------
void TransferGroup::setOverWrite( Transfer* caller, bool overwrite ) {
	QPtrListIterator<Transfer> it( m_transfers );
	for( ; it.current(); ++it ) {
		if( it.current() != caller )
			it.current()->setOverWrite( overwrite );
	}
}
//-----------------------------------------------
void TransferGroup::setSkip( Transfer* caller, bool skip ) {
	QPtrListIterator<Transfer> it( m_transfers );
	for( ; it.current(); ++it ) {
		if( it.current() != caller )
			it.current()->setSkip( skip );
	}
}
//-----------------------------------------------
void TransferGroup::addTransfer( Transfer* transfer ) {
	if( ! transfer )
		return;
	m_transfers.append( transfer );
}
//-----------------------------------------------
void TransferGroup::removeTransfer( Transfer* transfer ) {
	if( ! transfer )
		return;
	m_transfers.remove( transfer );
}
//-----------------------------------------------
