/*********************************************************************************
* C++ Interface: transfergroup.h
* Description:
*
* Begin : sn maj 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARTRANSFERGROUP_H
#define KBEARTRANSFERGROUP_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
#include <qptrlist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files

namespace KBear {
	class Transfer;

	/**
	@author Bjrn Sahlstrm
	*/
	class TransferGroup : public QObject {
			Q_OBJECT
		public:
			/** */
			TransferGroup( QObject *parent, int ID );
			/** */
			~TransferGroup();
			/** */
			void addTransfer( Transfer* );
			/** */
			void removeTransfer( Transfer* );
			/** */
			void setOverWrite( Transfer* caller, bool overwrite = true );
			/** */
			void setSkip( Transfer* caller, bool skip = true );
			/** */
			bool isEmpty() const { return m_transfers.isEmpty(); }
			/** */
			int ID() const { return m_ID; }
			/** */
			QPtrList<Transfer>* transfers() { return &m_transfers; }
		private:
			QPtrList<Transfer> m_transfers;
			int m_ID;
	};

};

#endif
