/*********************************************************************************
* C++ Interface: transfermanager.h
* Description:
*                              
* Begin : tis jan 15 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARTRANSFERMANAGER_H
#define KBEARTRANSFERMANAGER_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
#include <qguardedptr.h>
#include <qevent.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kdialogbase.h>
#include <kwizard.h>
#include <kio/global.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearconfigwidgetiface.h"


class QLCDNumber;
class QCheckBox;
class QRadioButton;
class QVBoxLayout;
class KEditListBox;
class KURLDrag;


namespace KBear {
	class Transfer;
	class TransferGroup;

/**
 *
 * @author Bjrn Sahlstrm
 **/
	class TransferManager : public QObject {
		Q_OBJECT
	public:
		/** */
		virtual ~TransferManager();
		/** */
		static TransferManager* getInstance();
		/** */
		void setTransferCommand( long ID, unsigned int cmd );
		/** */
		int numOfActiveTransfers() const;
		/** */
		int numOfQueuedTransfers() const;
		/** */
		unsigned int transferMode() const;
		/** */
		void setTransferMode( unsigned int );
		/** */
		void setOverWrite( bool overwrite );
		/**
		* Set this to false if you don't want the TransferManager to start directly.
		* This can be usefull for plugins that want to control the start of transfers.
		* By default this is set to start directly.
		*/
		void setStartTransfersDirectly( bool s );
		/**
		* @return if transfers are started directly or not.
		* @see #setStartTransfersDirectlyThis
		*/
		bool startTransfersDirectly() const;
		/**
		* Order a emit of the @ref #configChanged signal
		*/
		void emitConfigChanged();
		/** */
		KBear::KBearConfigWidgetIface* configWidget() const;
		/** */
		TransferGroup* addTransfers( KURLDrag* );
		/** */
		void removeTransfer( long );
		/** */
		void readSettings();
		/** */
		void saveSettings();
		/** */
		void cleanUp();
	public slots:
		/** */
		void slotConfigWidget( KDialogBase* dlg );
		/** */
		void slotConfigWidget( KWizard* wiz );
	signals:
		/**
		* Emitted whenever the configuration is changed
		*/
		void configChanged();
		/**
		* Emitted whenever the transfer mode is changed
		*/
		void transferModeChanged( unsigned int );
		/** */
		void transferAdded( long, Transfer* );
		/** */
		void transferGroupAdded( int, TransferGroup* );
		/**
		Emitted just before the transfer is remove
		*/
		void removingTransfer( long );
		/**
		Emitted just before the group is remove
		*/
		void removingTransferGroup( int );
		/**
		* This signal is emitted when either the transfer has finished or it has been canceled
		*/
		void transferDone( long );
		/** */
		void statusChanged( long, unsigned int );
		/** */
		void progress( long, unsigned long );
		/** */
		void totalFiles( long, unsigned long files );
		/** */
		void totalDirs( long, unsigned long dirs );
		/** */
		void processedFiles( long, unsigned long files );
		/** */
		void processedDirs( long, unsigned long dirs );
		/** */
		void copying( long, const KURL& from, const KURL& to );
		/** */
		void moving( long, const KURL& from, const KURL& to );
		/** */
		void creatingDir( long, const KURL& dir );
		/** */
		void renamed( long, const KURL& from, const KURL& to );
		/** */
		void totalSize( long, KIO::filesize_t size );
		/** */
		void processedSize( long, KIO::filesize_t size );
		/** */
		void speed( long, unsigned long bytes_per_second );
	private slots:
		void slotTransferStatusChanged( long ID, unsigned int status );
		void slotShutDownRequested();
		void slotMetaDataNeeded( KIO::MetaData& );
		void slotSaveConfig();
	private:
		TransferManager();
		void removeTransfer( Transfer* transfer, bool quietly=false );
		long getNewID();
		int getNewGroupID();
		void setTransferCommand( Transfer* , unsigned int cmd );
		void connectTransfer( Transfer* );
		int countForStatus( unsigned int status ) const;
	private:
		static TransferManager* s_instance;
		class KBearQueryExit;
		class TransferConfigWidget;
		class TransferManagerPrivate;
		TransferManagerPrivate* d;
};

}
#endif
