/***************************************************************************
                          kbearchmodjob.h  -  description
                             -------------------
    begin                : tis sep 17 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARCHMODJOB_H
#define KBEARCHMODJOB_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qstring.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kio/jobclasses.h>
#include <kio/chmodjob.h>
#include <kio/global.h>
#include <kfileitem.h>
#include <kurl.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files


/*

 NOTE : This job is currently in ksycoca because kfileitem needs to know
 about mimetypes. For KDE 3.0, make a base class for KFileItem, that holds
 all the information except the mimetype, so that jobs can use it.

*/



	 /**
     * This job changes permissions on a list of files or directories,
     * optionally in a recursive manner.
     */
    class KBearChmodJob : public KIO::Job
    {
        Q_OBJECT
    public:
		struct ChmodInfo
		{
			KURL url;
			int permissions;
		};
        KBearChmodJob( int id, const KFileItemList & lstItems,  int permissions, int mask,
                  int newOwner, int newGroup,
                  bool recursive, bool showProgressInfo );

    /**
     * Creates a job that changes permissions/ownership on several files or directories,
     * optionally recursively.
     * This version of chmod uses a KFileItemList so that it directly knows
     * what to do with the items. TODO: a version that takes a KURL::List,
     * and a general job that stats each url and returns a KFileItemList.
     *
     * Note that change of ownership is only supported for local files.
     *
     * Inside directories, the "x" bits will only be changed for files that had
     * at least one "x" bit before, and for directories.
     * This emulates the behaviour of chmod +X.
     *
     * @param lstItems The file items representing several files or directories.
     * @param permissions the permissions we want to set
     * @param mask the bits we are allowed to change
     * For instance, if mask is 0077, we don't change
     * the "user" bits, only "group" and "others".
     * @param newOwner If non-empty, the new owner for the files
     * @param newGroup If non-empty, the new group for the files
     * @param recursive whether to open directories recursively
     *
     * @return The job handling the operation.
     */
    static KBearChmodJob * chmod( int id, const KFileItemList& lstItems, int permissions, int mask,
                      QString newOwner, QString newGroup,
                      bool recursive, bool showProgressInfo = true );
    protected:
        void chmodNextFile();

    protected slots:

        virtual void slotResult( KIO::Job *job );
        void slotEntries( KIO::Job * , const KIO::UDSEntryList & );
        void processList();

    private:
        enum { STATE_LISTING, STATE_CHMODING } state;
        int m_permissions;
        int m_mask;
        int m_newOwner;
        int m_newGroup;
        bool m_recursive;
        KFileItemList m_lstItems;
        QValueList<ChmodInfo> m_infos;
		  int m_ID;



};

#endif
