 /***************************************************************************
                          kbearlistjob.h  -  description
                             -------------------
    begin                : sn apr 28 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARLISTJOB_H
#define KBEARLISTJOB_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kurl.h>
#include <kio/jobclasses.h>
#include <kio/job.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files


class KBearListJob : public KIO::SimpleJob {
		Q_OBJECT
	public:
		KBearListJob( int ID, const KURL& url, bool showProgressInfo,
		bool recursive = false, QString prefix = QString::null,
		bool includeHidden = true);
		virtual void start( KIO::Slave *slave );
		/** */
		static KBearListJob* listRecursive( int ID,const KURL& url, bool showProgressInfo, bool includeHidden );
		/** */
		static KBearListJob* listDir( int ID,const KURL& url, bool showProgressInfo, bool includeHidden );

	signals:
		/**
		* This signal emits the entry found by the job while listing.
		* The progress signals aren't specific to ListJob. It simply
		* uses SimpleJob's @ref #processedSize (number of entries listed) and
		* @ref #totalSize (total number of entries, if known),
		* as well as percent.
		*/
		void entries( KIO::Job *, const KIO::UDSEntryList& );

		/**
		* Signals a redirection.
		* Use to update the URL shown to the user.
		* The redirection itself is handled internally.
		*/
		void redirection( KIO::Job *, const KURL &url );

		/**
		* Signals a permanent redirection.
		* The redirection itself is handled internally.
		* @since 3.1
		*/
		void permanentRedirection( KIO::Job *, const KURL &fromUrl, const KURL &toUrl );

	protected slots:
		virtual void slotFinished( );
		virtual void slotResult( KIO::Job *job );
		void slotListEntries( const KIO::UDSEntryList& list );
		void slotRedirection( const KURL &url );
		void gotEntries( KIO::Job * subjob, const KIO::UDSEntryList& list );

	private:
		bool recursive;
		bool includeHidden;
		QString prefix;
		unsigned long m_processedEntries;
		KURL m_redirectionURL;
		int m_ID;
	private:
		class KBearListJobPrivate* d;
};

#endif
