/***************************************************************************
                          kbeardirview.h  -  description
                             -------------------
    begin                : Sun Jun 4 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARDIRVIEW_H
#define KBEARDIRVIEW_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qmessagebox.h>
#include <qdragobject.h>
#include <qtimer.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klistview.h>
#include <klocale.h>
#include <kfileitem.h>
#include <kurl.h>
#include <kurldrag.h>
#include <klistview.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeartreeview.h"
#include "kbeardirviewitem.h"
#include "siteinfo.h"

class QStringList;

namespace KBear {
	/**
	*@author Bjrn Sahlstrm
	**/

	class KBearDirView : public KBearTreeView  {
		Q_OBJECT
	public:
		/** Constructor */
		KBearDirView( QWidget *parent, const char *name, const SiteInfo& s );
		/** Destructor */
		virtual ~KBearDirView();
		/**
		* Call this to set the path to be used as 'home path'.
		* This means the directory that will be marked with the 'home' pixmap.
		*/
		void setHomeURL( const KURL& url );
		/** */
		KURL homeURL() const { return m_homeURL; }
		/** */
		virtual bool isLocal() const { return m_siteInfo.isLocal(); }
	signals: // Signals
	 	/** This signal is emitted whenever a directory is selected */
	 	void folderSelected( const KFileItem* );
		/**
		* Emitted whenever an decodable item is dropped in the view.
		*@param urls contains a list of all dropped @ref KURL
		*/
		void dropped( QMimeSource*, const QPoint& );
	public slots: // Public slots
		/**
		*sets the URL for the view
		*@see KURL
		*/
		void slotSetURL( const KURL& u );
		/**  */
		void slotStartAnimation();
		/**  */
		void slotStopAnimation();
		/**  */
		void slotInsertItems( const KFileItemList & list) ;
		/**  */
		void slotToggleShowHidden( bool show );
		/** Called when ever an item has been deleted */
		void slotDeleteItem( KFileItem* item );
		/**  */
		void slotPrepareForReread( const KURL& url );
	protected slots:
		/**
		*Reimplemented from @ref KListView
		*/
		virtual void contentsDropEvent( QDropEvent* e );
		/** */
		void slotExpanded( QListViewItem* );
		/** */
		virtual void slotExecuted( QListViewItem* );
		/** */
		void slotAnimation();
	protected: // Protected methods
		/**
		*Reimplemented from @ref KListView
		*/
		virtual void startDrag();
		/**
		*Reimplemented from @ref KListView
		*/
		virtual bool acceptDrag(QDropEvent* e ) const;
		void newDirEntry( KFileItem* );
		void deleteItem( const QString& delPath );
		void deleteHiddenItems();
		void loadAnimationPixmaps();
		void rebuildNewTree();
	protected: // Private attributes
		KURL m_url;
		QTimer m_animationTimer;
		int m_animationCounter;
		KURL m_homeURL;
		QStringList m_animationList;
		QListViewItem* m_animatedItem;
		SiteInfo m_siteInfo;
		class KBearDirViewPrivate;
		KBearDirViewPrivate* d;
	};
};
#endif
