/*********************************************************************************
* C++ Implementation: kbearfilesyswidget.h
* Description:
*
* Begin : mn apr 28 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARKBEARFILESYSWIDGET_H
#define KBEARKBEARFILESYSWIDGET_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qdir.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kfileview.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "siteinfo.h"

class KToolBar;
class KFileItem;
class KIO::Job;
class KParts::Part;

namespace KBear {
	class KBearDirListerIface;
	class KBearDirView;
	class KBearDirListerIface;
	class KBearFileSysPartInterface;

	/**
	This is the main widget in each filesyspart
	@author Bjrn Sahlstrm
	*/
	class KBearFileSysWidget : public QWidget {
		Q_OBJECT
	public:
		/** */
		KBearFileSysWidget( KBearFileSysPartInterface* part, QWidget *parent = 0, const char *name = 0, WFlags f = 0 );
		/** */
		~KBearFileSysWidget();
		/**
		Set the @ref SiteInfo
		*/
		void setSiteInfo( const SiteInfo& info );
		/**
		Open the connection specified by @ref #setSiteInfo. I f not set nothing happends
		*/
		void openConnection();
		/**
		Open the specified @ref KURL
		@param stat set this to true if you want to stst the @ref KURL first
		*/
		void openURL( const KURL&, bool reload = false, bool stat = true );
		/** */
		void stop();
		/** */
		void reload();
		/** */
		void embedPart( KParts::Part* );
		/**
		Set view type
		*/
		void setView( KFile::FileView view );
		/**
		@return a reference to the upper toolbar
		*/
		KFileView* fileView() const;
		/**
		Set the dirlister
		*/
		void setDirLister( KBearDirListerIface* dirLister );
		/**
		@return a reference to the dirlister
		*/
		KBearDirListerIface* dirLister() const;
		/**
		@return a reference to the dirlister
		*/
		KBearDirView* treeView() const;
		/**
		@return the current view kind (Detail or Simple )
		*/
		KFile::FileView viewKind() const;
		/**
		@return the current sorting
		*/
		QDir::SortSpec sorting() const;
		/**
		@return a reference to the upper toolbar
		*/
		KToolBar* toolBarUpper() const;
		/**
		@return a reference to the lower toolbar
		*/
		KToolBar* toolBarLower() const;
		/**
		Call this to make the progress widget visible
		*/
		void showProgress();
		/**
		Call this to hide the progress widget
		*/
		void hideProgress();
		/**
		Call this to store the size of the splitter
		@see restoreSplitterSize
		*/
		void storeSplitterSize();
		/**
		Call this to restore the size of the splitter stored in @ref storeSplitterSize
		*/
		void restoreSplitterSize();
		/**
		Call this to clear history items, path combo
		*/
		void clearHistory();
		/**
		Call this to set info text
		*/
		void setInfoText( const QString& txt );
		/**
		Call this to initialize the view
		*/
		void init( const SiteInfo& info );
		/** */
		void readConfig( KConfig* config, const QString& group );
		/** */
		void writeConfig( KConfig* config, const QString& group );
		/** */
		void setState( unsigned int state );
		/** */
		void toggleStatusBarUpper( bool show );
		/** */
		void toggleStatusBarLower( bool show );
		/** */
		void deleteSelectedItems( bool shred = false );
		/** */
		void addToHistory( const KURL& url );
	signals:
		/** */
		void pathActivated( const QString& );
		/** */
		void startedLoading();
		/** */
		void finishedLoading();
		/** */
		void sortingChanged();
		/** */
		void pathChanged();
		/** */
		void connected();
		/** */
		void newDir( const KURL& );
	public slots:
		/** */
		void slotOpenDir( const KURL& url );
		/** */
		void slotPathHasChanged();
		/**
		Call this to display a status message
		*/
		void slotStatusMessage( const QString& mess);
		/**
		Call this when listing started, will start animations etc.
		*/
		void slotStart();
		/**
		Call this when listing stopped, will stop animations etc.
		*/
		void slotStop();
		/**
		Call this to reverse the sorting
		*/
		void slotSortReversed();
		/** */
		void slotSortByName();
		/** */
		void slotSortBySize();
		/** */
		void slotSortByDate();
		/** */
		void slotToggleDirsFirst();
		/** */
		void slotToggleIgnoreCase();
		/** */
		void slotDetailedView();
		/** */
		void slotSimpleView();
		/** */
		void slotToggleTreeView( bool show );
		/** */
		void slotToggleHidden( bool show );
		/** */
		void resetCursor();
		/** */
		void slotProgress( int percent );
		/** */
		void slotSpeed( int speed );
		/** */
		void slotRename();
	private slots:
		void slotDeleteItem( KFileItem *item );
		void slotDirActivated(const KFileItem*);
		void slotFileSelected(const KFileItem*);
		void slotFilterChanged( const QString& nameFilter );
		void slotPathActivated( int item );
		void slotNewItems(const KFileItemList &newone);
		void slotRefreshItems( const KFileItemList& items );
	private:
		void connectView( KFileView *view );
		void setSorting( QDir::SortSpec );
		void setup();
	private:
		class KBearFileSysWidgetPrivate;
		KBearFileSysWidgetPrivate* d;
	};

};

#endif
