/***************************************************************************
                          kbeartextedit.cpp  -  description
                             -------------------
    begin                : Fri Apr 12 2002
    copyright            : (C) 2003 by Peter Svrd
    email                : tocool@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//////////////////////////////////////////////////////
// Qt specific includes
#include <qdir.h>
#include <qfile.h>
#include <qpopupmenu.h>
#include <qtextcodec.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <klocale.h>
#include <kfiledialog.h>
#include <kcharsets.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbeartextedit.h"
//////////////////////////////////////////////////////

#include "kbeartextedit.moc"

using namespace KBear;
//-----------------------------------------------
class KBearTextEditPrivate {
	public:
};
//-----------------------------------------------
KBearTextEdit::KBearTextEdit(QWidget* parent, const QString& name)
: QTextEdit(parent,name.latin1()), m_codec( 0L )
{
}
//-----------------------------------------------
KBearTextEdit::~KBearTextEdit()
{
}
//-----------------------------------------------
void KBearTextEdit::setEncoding( const QString& encoding ) {
	bool ok;
	m_codec = KGlobal::charsets()->codecForName( encoding, ok );
}
//-----------------------------------------------
void KBearTextEdit::append( const QString& txt ) {
	QString tmp = m_codec ? m_codec->toUnicode( txt.utf8() ) : txt;
	QTextEdit::append( tmp );
}
//-----------------------------------------------
QPopupMenu* KBearTextEdit::createPopupMenu(const QPoint & pos)
{
	m_popUp = QTextEdit::createPopupMenu(pos);

	/*int saveID =*/ m_popUp->insertItem(i18n("Save As..."), this, SLOT( slotSaveAs() ) );
  m_popUp->insertSeparator();
  /*int clearID =*/ m_popUp->insertItem(i18n("Cl&ear"), this, SLOT( clear() ) );
	
  return m_popUp;
}
//-----------------------------------------------
void KBearTextEdit::slotSaveAs()
{
	// copy & paste from manual
  QString f = KFileDialog::getSaveFileName( QDir::homeDirPath(), i18n("*|All files"), this, i18n("Save as...") );
  if(!f.isEmpty())
  {
  	QFile file( f );
    if ( file.open( IO_WriteOnly ) )
    {         	
        QTextStream ts( &file );
        selectAll();
        ts << selectedText();
        selectAll( false );
        file.close();
    }
  }	
}
//-----------------------------------------------
