/***************************************************************************
                          kbeartreeview.h  -  description
                             -------------------
    begin                : sn feb 10 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARTREEVIEW_H
#define KBEARTREEVIEW_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qtimer.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klistview.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeartreeviewitem.h"

namespace KBear {
	/**
	*@author Bjrn Sahlstrm
	*/

	class KBearTreeView : public KListView  {
		Q_OBJECT
	public: 
		/** */
		KBearTreeView(QWidget *parent=0, const char *name=0);
		/** */
		virtual ~KBearTreeView();
		/** Searches the arents childs for specified name
		*@param parent is the parent item to search within
		*@param name is the name to search for
		*@return a pointer to the found item or NULL
		*/
		QListViewItem* findItemByName( const QListViewItem* parent, const QString& name );
		/** Searches the hole tree for specified group name
		*@param parent is the hole search path for the parent name to search for
		*@param name is the name to search for
		*@return a pointer to the found parent or NULL
		*/
		QListViewItem* findParentByFullName( const QString& name );
		/**
		* @param enable set this to false if you don't want DND.
		* By default DND is ON.
		*/
		void setDNDEnabled( bool enable = true );
	signals: // Signals
		/** Emitted whenever a decodable item is dropped in the view */
		void dropped( QDropEvent* );
		/** Emitted whenever a decodable item is dropped in the view */
		void dropped( KBearTreeView*, QDropEvent* );
		/** Emitted whenever a decodable item is dropped in the view */
		void dropped (KBearTreeView*, QDropEvent*, QListViewItem* after );
		/** Emitted whenever a decodable item is dropped in the view */
		void dropped (KBearTreeView*, QDropEvent*, QListViewItem* parent, QListViewItem* after );
	protected slots:
		/** */
		virtual void slotExecuted( QListViewItem* );
		/** Called whenever the autoOpenTimer expires */
		void slotOpenFolder();
	protected: // Protected methods
		/**
		*Reimplemented from @ref KListView
		*/
		virtual void contentsDragEnterEvent( QDragEnterEvent *e );
		/**
		*Reimplemented from @ref KListView
		*/
		virtual void contentsDragMoveEvent( QDragMoveEvent *e );
		/**
		*Reimplemented from @ref KListView
		*/
		virtual void contentsDragLeaveEvent( QDragLeaveEvent *e );
		/**
		*Reimplemented from @ref KListView
		*/
		virtual void contentsDropEvent( QDropEvent* e );
	protected: // Private attributes
		QListViewItem* m_dropItem;
		QListViewItem* m_currentBeforeDropItem;
		QTimer m_autoOpenTimer;
		class KBearTreeViewPrivate;
		KBearTreeViewPrivate* d;
	};
};
#endif
