/**************************************************************************
*                        kfiledndiconview.h  -  description
*                          -------------------
*  begin                : Wed Nov 1 2000
*  copyright            : (C) 2000 by Bjrn Sahlstrm
*  email                : kbjorn@users.sourceforge.net
***************************************************************************/

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#ifndef KFILEDNDICONVIEW_H
#define KFILEDNDICONVIEW_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
#include <qmap.h>
#include <qtimer.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kfileiconview.h>
#include <kurldrag.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearfileviewinterface.h"

namespace KBear {
	/**
	*This is a fileview inherited from @ref KFileIconView.
	*It adds "drag and drop" suitable for a @ref KFileIconView
	* No special setup is needed, just connect to the @ref dropped signals
	* and the view will take care of the rest.
	*@short Drag and drop" aware @ref KFileIconView	
 	*@author Bjrn Sahlstrm
	*/

	class KFileDnDIconView : public KFileIconView  {
		Q_OBJECT
	public: // Public methods
		/** */
		KFileDnDIconView(QWidget *parent=0, const char *name=0);
		/** */
		virtual ~KFileDnDIconView();
		/**
		* Set if Drag'n drop should be enabled or not, default is enabled.
		*/
		void setDnDEnabled( bool );
		/**
		* @return wether DnD is enabled or not.
		*/
		bool isDnDEnabled() const { return m_dndEnabled; }
		/**
		*Sets the auto open time, which means the time that will
		*elapse before a directory is automatically opened after entered by DnD.
		*Only need to call this if you want to change the predefined time that is 750 ms.
		*This also calls @ref #useAutoOpenTimer so no need to call this to.
		*/
		void setAutoOpenTime( const int& time );
		/**
		*Set this to true if you want the view to use it's auto open functionallity otherwhise set it to false.
		*By default this is turned ON.
		*/
		void useAutoOpenTimer( bool on=true );
		/**
		*@return true if auto open functionallity is turned ON (default), otherwhise false
		*@see #useAutoOpenTimer
		*@see #setAutoOpenTime
		*/
		bool isAutoOpening() const { return m_useAutoOpenTimer; }
		/** */
		virtual void readConfig( KConfig*, const QString& group = QString::null );
		/** */
		virtual void writeConfig( KConfig*, const QString& group = QString::null );
		/** */
		virtual void insertItem( KFileItem* );
	signals: // Signals
		/**
		* Emitted whenever an decodable item is dropped in the view.
		*@param urls contains a list of all dropped @ref KURL
		*/
		void dropped( QMimeSource*, const QPoint& );
	protected slots: // Protected slots
		/**
		* Called when the auto timer times out. Open the current folder.
		*/
		void slotOpenFolder();
	protected: // Protected methods
		/**  */
		virtual void contentsDragEnterEvent( QDragEnterEvent *e );
		/**  */
		virtual void contentsDragMoveEvent( QDragMoveEvent *e );
		/**  */
		virtual void contentsDragLeaveEvent( QDragLeaveEvent *e );
		/**  */
		virtual void contentsDropEvent( QDropEvent* e );
	/**
	* Create dragobject encoding the current selection and starts the drag
	*/
		virtual void startDrag() = 0;
		/**
		*@return true if we can decode the drag and support the action
		*/
		virtual bool acceptDrag(QDropEvent* event) const;
	protected: // Private attributes
		QTimer m_autoOpenTimer;
		int m_autoOpenTime;
		bool m_useAutoOpenTimer;
		QIconViewItem* m_dropItem;
		bool m_dndEnabled;
		KURLDrag* m_dragObject;
		class KFileDnDIconViewPrivate;
		KFileDnDIconViewPrivate* d;
	};
};
#endif
