/*********************************************************************************
* C++ Implementation: miscsettingsbase.cpp
* Description:
*
* Begin : tis apr 21 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/


//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qframe.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kcombobox.h>
#include <kconfig.h>
#include <kapplication.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "miscsettingswidget.h"

#include "miscsettingswidget.moc"

using namespace KBear;

//-----------------------------------------------
MiscSettingsWidget* MiscSettingsWidget::s_instance = 0L;
//-----------------------------------------------
MiscSettingsWidget::MiscSettingsWidget( QWidget* parent, const char* name )
	:	KBearConfigWidgetIface( parent, name )
{
	setupGUI();
	s_instance = this;
	readSettings();
}
//-----------------------------------------------
MiscSettingsWidget::~MiscSettingsWidget() {
	s_instance = 0L;
}
//-----------------------------------------------
void MiscSettingsWidget::swallow( QWidget* widget ) {
	if( ! widget )
		return;
	m_layout->removeItem( m_endSpacer );
	m_layout->addWidget( widget );
	m_layout->addItem( m_endSpacer );
	m_layout->activate();
}
//-----------------------------------------------
QString MiscSettingsWidget::helpSection() const {
	return QString::fromLatin1( "misc-settings" );
}
//--------------------------------------------
void MiscSettingsWidget::setDefaultEmail( const QString& email ) {
	QString tmp = QString::null;
	// read default email for use as password on anonymous servers
	KConfig* conf =  new KConfig("emaildefaults");
	QStringList groupList = conf->groupList();
	for( QStringList::Iterator it = groupList.begin(); it != groupList.end(); it++ ) {
		conf->setGroup( (*it) );
		tmp = conf->readEntry( "EmailAddress" );
		if( ! tmp.isNull() ) {
			m_emailComboBox->insertItem( tmp );
		}
	}
	if( ! email.isNull() ) {
		m_emailComboBox->setCurrentItem( email, true );
	}
	delete conf;
}
//-----------------------------------------------
void MiscSettingsWidget::readSettings( bool defaultSettings ) {
	KConfig* config = kapp->config();
	KConfigGroupSaver( config, config->group() );
	config->setGroup("General");
	if( defaultSettings ) {
		config->deleteEntry( QString::fromLatin1("Run Time Settings" ) );
		config->deleteEntry( QString::fromLatin1("Default Email" ) );
		config->sync();
	}
	m_runtimeSettingsCheckBox->setChecked( config->readBoolEntry( "Run Time Settings", true) );
	setDefaultEmail( config->readEntry( "Default Email", QString::null ) );
}
//-----------------------------------------------
void MiscSettingsWidget::saveSettings() {
	KConfig* config = kapp->config();
	KConfigGroupSaver( config, config->group() );
	config->setGroup( "General" );
	config->writeEntry( "Run Time Settings", m_runtimeSettingsCheckBox->isChecked() );
	if( m_emailComboBox->currentText() != "" )
		kapp->config()->writeEntry( "Default Email", m_emailComboBox->currentText() );

	config->sync();

	emit newSettings();
}
//-----------------------------------------------
void MiscSettingsWidget::setupGUI() {
	m_layout = new QVBoxLayout( this, 11, 6, "m_layout");

	QLabel* infoLabel = new QLabel( this );
	infoLabel->setText( i18n( "<p>This page contains settings for miscellanous things. "
														"The content will look slightly different depending on which plugins are loaded.</p>" ) );
	infoLabel->setAlignment( int( QLabel::WordBreak | QLabel::AlignTop ) );

	m_layout->addWidget( infoLabel );

	QFrame* emailFrame = new QFrame( this, "emailFrame" );
	emailFrame->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed, 0, 0, emailFrame->sizePolicy().hasHeightForWidth() ) );
	emailFrame->setMinimumSize( QSize( 0, 45 ) );
	emailFrame->setFrameShape( QFrame::Box );
	emailFrame->setFrameShadow( QFrame::Raised );
	QHBoxLayout* emailFrameLayout = new QHBoxLayout( emailFrame, 11, 6, "emailFrameLayout");

	QLabel* emailLabel = new QLabel( i18n( "Email Address:" ), emailFrame, "emailLabel" );
	emailLabel->setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::Preferred, 0, 0, emailLabel->sizePolicy().hasHeightForWidth() ) );
	emailFrameLayout->addWidget( emailLabel );

	m_emailComboBox = new KComboBox( false, emailFrame, "m_emailComboBox" );
	m_emailComboBox->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed, 0, 0, m_emailComboBox->sizePolicy().hasHeightForWidth() ) );
	m_emailComboBox->setEditable( true );
	m_emailComboBox->setSizeLimit( 25 );
	m_emailComboBox->setDuplicatesEnabled( false );
	m_emailComboBox->setURLDropsEnabled( true );
	QString tmp = i18n( "Enter the email adress you want to use as password on anonymous servers." );
	QToolTip::add( m_emailComboBox, tmp );
	QWhatsThis::add( m_emailComboBox, tmp );

	emailFrameLayout->addWidget( m_emailComboBox );

	m_layout->addWidget( emailFrame );

	QGroupBox* saveSettingsGroupBox = new QGroupBox( this, "saveSettingsGroupBox" );
	saveSettingsGroupBox->setTitle( QString::null );
	saveSettingsGroupBox->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed, 0, 0, saveSettingsGroupBox->sizePolicy().hasHeightForWidth() ) );
	saveSettingsGroupBox->setColumnLayout(0, Qt::Vertical );
	saveSettingsGroupBox->layout()->setSpacing( 6 );
	saveSettingsGroupBox->layout()->setMargin( 11 );
	QGridLayout* saveSettingsGroupBoxLayout = new QGridLayout( saveSettingsGroupBox->layout() );
	saveSettingsGroupBoxLayout->setAlignment( Qt::AlignTop );

	m_runtimeSettingsCheckBox = new QCheckBox( saveSettingsGroupBox, "m_runtimeSettingsCheckBox" );
	m_runtimeSettingsCheckBox->setText( i18n( "Save settings used when closing the application." ) );
	m_runtimeSettingsCheckBox->setChecked( true );
	tmp = i18n( "Check this option if you want the settings used when closing the application to be the default at next startup.  "
								"WARNING!!! This will override all settings on this page !" );
	QToolTip::add( m_runtimeSettingsCheckBox, tmp );
	QWhatsThis::add( m_runtimeSettingsCheckBox, tmp );

	saveSettingsGroupBoxLayout->addWidget( m_runtimeSettingsCheckBox, 0, 0 );
	m_layout->addWidget( saveSettingsGroupBox );

	m_endSpacer = new QSpacerItem( 20, 41, QSizePolicy::Minimum, QSizePolicy::Expanding );
	m_layout->addItem( m_endSpacer );
	m_layout->activate();
}
//-----------------------------------------------

