
#ifndef MISCSETTINGSWIDGET_H
#define MISCSETTINGSWIDGET_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwidget.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearconfigwidgetiface.h"

class KComboBox;
class QGroupBox;
class QCheckBox;
class QVBoxLayout;
class QSpacerItem;

class MiscSettingsWidget : public KBear::KBearConfigWidgetIface {
	Q_OBJECT
public:
	/** */
	MiscSettingsWidget( QWidget* parent = 0, const char* name = 0 );
	/** */
	~MiscSettingsWidget();
	/** Note that this may return NULL*/
	static MiscSettingsWidget* getInstance() { return s_instance; }
	/**
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual QString helpSection() const;
	/**
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual bool helpEnabled() const { return true; }
	/**
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual void readSettings( bool defaultSettings = false );
	/**
	* Reimplement from @ref KBear::KBearConfigWidgetIface
	*/
	virtual void saveSettings();
	/** */
	virtual void swallow( QWidget*);
	/**  */
	void setDefaultEmail( const QString& email );
signals:
	void newSettings();
private slots:
	void slotSaveSettings() { saveSettings(); }
private:
	void setupGUI();
private:
	KComboBox* m_emailComboBox;
	QGroupBox* saveSettingsGroupBox;
	QCheckBox* m_runtimeSettingsCheckBox;
	QVBoxLayout* m_layout;
	QSpacerItem* m_endSpacer;
	static MiscSettingsWidget* s_instance;
};

#endif // MISCSETTINGSWIDGET_H
